/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class DomainNetworkRoute
implements Serializable {
    private String prefix = null;
    private String nexthop = null;
    private Boolean persistent = null;
    private Integer metric = null;
    private FamilyEnum family = null;

    public DomainNetworkRoute prefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @ApiModelProperty(example="null", value="The IPv4 or IPv6 route prefix in CIDR notation.")
    @JsonProperty(value="prefix")
    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public DomainNetworkRoute nexthop(String nexthop) {
        this.nexthop = nexthop;
        return this;
    }

    @ApiModelProperty(example="null", value="The IPv4 or IPv6 nexthop IP address.")
    @JsonProperty(value="nexthop")
    public String getNexthop() {
        return this.nexthop;
    }

    public void setNexthop(String nexthop) {
        this.nexthop = nexthop;
    }

    public DomainNetworkRoute persistent(Boolean persistent) {
        this.persistent = persistent;
        return this;
    }

    @ApiModelProperty(example="null", value="True if this route will persist on Edge restart.  Routes assigned by DHCP will be returned as false.")
    @JsonProperty(value="persistent")
    public Boolean getPersistent() {
        return this.persistent;
    }

    public void setPersistent(Boolean persistent) {
        this.persistent = persistent;
    }

    public DomainNetworkRoute metric(Integer metric) {
        this.metric = metric;
        return this;
    }

    @ApiModelProperty(example="null", value="The metric being used for route. Lower values will have a higher priority.")
    @JsonProperty(value="metric")
    public Integer getMetric() {
        return this.metric;
    }

    public void setMetric(Integer metric) {
        this.metric = metric;
    }

    public DomainNetworkRoute family(FamilyEnum family) {
        this.family = family;
        return this;
    }

    @ApiModelProperty(example="null", value="The address family for this route.")
    @JsonProperty(value="family")
    public FamilyEnum getFamily() {
        return this.family;
    }

    public void setFamily(FamilyEnum family) {
        this.family = family;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DomainNetworkRoute domainNetworkRoute = (DomainNetworkRoute)o;
        return Objects.equals(this.prefix, domainNetworkRoute.prefix) && Objects.equals(this.nexthop, domainNetworkRoute.nexthop) && Objects.equals(this.persistent, domainNetworkRoute.persistent) && Objects.equals(this.metric, domainNetworkRoute.metric) && Objects.equals((Object)this.family, (Object)domainNetworkRoute.family);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.prefix, this.nexthop, this.persistent, this.metric, this.family});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DomainNetworkRoute {\n");
        sb.append("    prefix: ").append(this.toIndentedString(this.prefix)).append("\n");
        sb.append("    nexthop: ").append(this.toIndentedString(this.nexthop)).append("\n");
        sb.append("    persistent: ").append(this.toIndentedString(this.persistent)).append("\n");
        sb.append("    metric: ").append(this.toIndentedString(this.metric)).append("\n");
        sb.append("    family: ").append(this.toIndentedString((Object)this.family)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=FamilyEnumDeserializer.class)
    public static enum FamilyEnum {
        OUTDATEDSDKVERSION(-1),
        NUMBER_2(2),
        NUMBER_23(23);

        private Integer value;

        private FamilyEnum(Integer value) {
            this.value = value;
        }

        @JsonCreator
        public static FamilyEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (FamilyEnum value : FamilyEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return FamilyEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class FamilyEnumDeserializer
    extends StdDeserializer<FamilyEnum> {
        public FamilyEnumDeserializer() {
            super(FamilyEnumDeserializer.class);
        }

        public FamilyEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return FamilyEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

