/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.ExportScriptRequest;
import java.util.HashMap;
import java.util.Map;

public class PostScriptExportRequest {
    private String scriptId;
    private ExportScriptRequest body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getScriptId() {
        return this.scriptId;
    }

    public void setScriptId(String scriptId) {
        this.scriptId = scriptId;
    }

    public PostScriptExportRequest withScriptId(String scriptId) {
        this.setScriptId(scriptId);
        return this;
    }

    public ExportScriptRequest getBody() {
        return this.body;
    }

    public void setBody(ExportScriptRequest body) {
        this.body = body;
    }

    public PostScriptExportRequest withBody(ExportScriptRequest body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PostScriptExportRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<ExportScriptRequest> withHttpInfo() {
        if (this.scriptId == null) {
            throw new IllegalStateException("Missing the required parameter 'scriptId' when building request for PostScriptExportRequest.");
        }
        return ApiRequestBuilder.create("POST", "/api/v2/scripts/{scriptId}/export").withPathParameter("scriptId", this.scriptId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String scriptId) {
        return new Builder().withRequiredParams(scriptId);
    }

    public static class Builder {
        private final PostScriptExportRequest request = new PostScriptExportRequest();

        private Builder() {
        }

        public Builder withScriptId(String scriptId) {
            this.request.setScriptId(scriptId);
            return this;
        }

        public Builder withBody(ExportScriptRequest body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String scriptId) {
            this.request.setScriptId(scriptId);
            return this;
        }

        public PostScriptExportRequest build() {
            if (this.request.scriptId == null) {
                throw new IllegalStateException("Missing the required parameter 'scriptId' when building request for PostScriptExportRequest.");
            }
            return this.request;
        }
    }
}

