/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

public class Contact
implements Serializable {
    private String address = null;
    private String display = null;
    private MediaTypeEnum mediaType = null;
    private TypeEnum type = null;
    private String extension = null;

    public Contact address(String address) {
        this.address = address;
        return this;
    }

    @ApiModelProperty(example="null", value="Email address or phone number for this contact type")
    @JsonProperty(value="address")
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    @ApiModelProperty(example="null", value="Formatted version of the address property")
    @JsonProperty(value="display")
    public String getDisplay() {
        return this.display;
    }

    public Contact mediaType(MediaTypeEnum mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="mediaType")
    public MediaTypeEnum getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(MediaTypeEnum mediaType) {
        this.mediaType = mediaType;
    }

    public Contact type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public Contact extension(String extension) {
        this.extension = extension;
        return this;
    }

    @ApiModelProperty(example="null", value="Use extension instead of address for setting internal extensions")
    @JsonProperty(value="extension")
    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Contact contact = (Contact)o;
        return Objects.equals(this.address, contact.address) && Objects.equals(this.display, contact.display) && Objects.equals((Object)this.mediaType, (Object)contact.mediaType) && Objects.equals((Object)this.type, (Object)contact.type) && Objects.equals(this.extension, contact.extension);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.address, this.display, this.mediaType, this.type, this.extension});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Contact {\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    display: ").append(this.toIndentedString(this.display)).append("\n");
        sb.append("    mediaType: ").append(this.toIndentedString((Object)this.mediaType)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    extension: ").append(this.toIndentedString(this.extension)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        PRIMARY("PRIMARY"),
        WORK("WORK"),
        WORK2("WORK2"),
        WORK3("WORK3"),
        WORK4("WORK4"),
        HOME("HOME"),
        MOBILE("MOBILE"),
        MAIN("MAIN");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum MediaTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        PHONE("PHONE"),
        EMAIL("EMAIL"),
        SMS("SMS");

        private String value;

        private MediaTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MediaTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MediaTypeEnum value : MediaTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MediaTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

