/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.TimeOffLimitReference;
import com.mypurecloud.sdk.v2.model.TimeOffRequestReference;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Objects;

public class WaitlistPosition
implements Serializable {
    private TimeOffRequestReference timeOffRequest = null;
    private TimeOffLimitReference timeOffLimit = null;
    private LocalDate date = null;
    private Integer waitlistPosition = null;

    public WaitlistPosition timeOffRequest(TimeOffRequestReference timeOffRequest) {
        this.timeOffRequest = timeOffRequest;
        return this;
    }

    @ApiModelProperty(example="null", value="The time off request for this wait list position")
    @JsonProperty(value="timeOffRequest")
    public TimeOffRequestReference getTimeOffRequest() {
        return this.timeOffRequest;
    }

    public void setTimeOffRequest(TimeOffRequestReference timeOffRequest) {
        this.timeOffRequest = timeOffRequest;
    }

    public WaitlistPosition timeOffLimit(TimeOffLimitReference timeOffLimit) {
        this.timeOffLimit = timeOffLimit;
        return this;
    }

    @ApiModelProperty(example="null", value="The time off limit for which time off request is waitlisted")
    @JsonProperty(value="timeOffLimit")
    public TimeOffLimitReference getTimeOffLimit() {
        return this.timeOffLimit;
    }

    public void setTimeOffLimit(TimeOffLimitReference timeOffLimit) {
        this.timeOffLimit = timeOffLimit;
    }

    public WaitlistPosition date(LocalDate date) {
        this.date = date;
        return this;
    }

    @ApiModelProperty(example="null", value="The date to which this wait list position applies, as defined by the time zone of the business unit. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd")
    @JsonProperty(value="date")
    public LocalDate getDate() {
        return this.date;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    public WaitlistPosition waitlistPosition(Integer waitlistPosition) {
        this.waitlistPosition = waitlistPosition;
        return this;
    }

    @ApiModelProperty(example="null", value="The time off request's position in the waitlist on the date. 1 means time off is the first in the waitlist")
    @JsonProperty(value="waitlistPosition")
    public Integer getWaitlistPosition() {
        return this.waitlistPosition;
    }

    public void setWaitlistPosition(Integer waitlistPosition) {
        this.waitlistPosition = waitlistPosition;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WaitlistPosition waitlistPosition = (WaitlistPosition)o;
        return Objects.equals(this.timeOffRequest, waitlistPosition.timeOffRequest) && Objects.equals(this.timeOffLimit, waitlistPosition.timeOffLimit) && Objects.equals(this.date, waitlistPosition.date) && Objects.equals(this.waitlistPosition, waitlistPosition.waitlistPosition);
    }

    public int hashCode() {
        return Objects.hash(this.timeOffRequest, this.timeOffLimit, this.date, this.waitlistPosition);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WaitlistPosition {\n");
        sb.append("    timeOffRequest: ").append(this.toIndentedString(this.timeOffRequest)).append("\n");
        sb.append("    timeOffLimit: ").append(this.toIndentedString(this.timeOffLimit)).append("\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    waitlistPosition: ").append(this.toIndentedString(this.waitlistPosition)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

