/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;

public class TouchpointResponse
implements Serializable {
    private String conversationId = null;
    private String agentId = null;
    private BigDecimal associatedValue = null;
    private MediaTypeEnum mediaType = null;
    private StateEnum state = null;
    private String message = null;
    private Date createdDate = null;

    public TouchpointResponse conversationId(String conversationId) {
        this.conversationId = conversationId;
        return this;
    }

    @ApiModelProperty(example="null", value="ID of conversation.")
    @JsonProperty(value="conversationId")
    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public TouchpointResponse agentId(String agentId) {
        this.agentId = agentId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="ID of agent.")
    @JsonProperty(value="agentId")
    public String getAgentId() {
        return this.agentId;
    }

    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    public TouchpointResponse associatedValue(BigDecimal associatedValue) {
        this.associatedValue = associatedValue;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The value attributed to this touchpoint.")
    @JsonProperty(value="associatedValue")
    public BigDecimal getAssociatedValue() {
        return this.associatedValue;
    }

    public void setAssociatedValue(BigDecimal associatedValue) {
        this.associatedValue = associatedValue;
    }

    public TouchpointResponse mediaType(MediaTypeEnum mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    @ApiModelProperty(example="null", value="Media Type of the touchpoint; allowed values are Email, Message and Voice.")
    @JsonProperty(value="mediaType")
    public MediaTypeEnum getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(MediaTypeEnum mediaType) {
        this.mediaType = mediaType;
    }

    public TouchpointResponse state(StateEnum state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Outcome Attribution Touchpoint status.")
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public TouchpointResponse message(String message) {
        this.message = message;
        return this;
    }

    @ApiModelProperty(example="null", value="Additional information on the state of the touchpoint entity, populated when the touchpoint has an error.")
    @JsonProperty(value="message")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public TouchpointResponse createdDate(Date createdDate) {
        this.createdDate = createdDate;
        return this;
    }

    @ApiModelProperty(example="null", value="Date conversation happened. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="createdDate")
    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TouchpointResponse touchpointResponse = (TouchpointResponse)o;
        return Objects.equals(this.conversationId, touchpointResponse.conversationId) && Objects.equals(this.agentId, touchpointResponse.agentId) && Objects.equals(this.associatedValue, touchpointResponse.associatedValue) && Objects.equals((Object)this.mediaType, (Object)touchpointResponse.mediaType) && Objects.equals((Object)this.state, (Object)touchpointResponse.state) && Objects.equals(this.message, touchpointResponse.message) && Objects.equals(this.createdDate, touchpointResponse.createdDate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.conversationId, this.agentId, this.associatedValue, this.mediaType, this.state, this.message, this.createdDate});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TouchpointResponse {\n");
        sb.append("    conversationId: ").append(this.toIndentedString(this.conversationId)).append("\n");
        sb.append("    agentId: ").append(this.toIndentedString(this.agentId)).append("\n");
        sb.append("    associatedValue: ").append(this.toIndentedString(this.associatedValue)).append("\n");
        sb.append("    mediaType: ").append(this.toIndentedString((Object)this.mediaType)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    createdDate: ").append(this.toIndentedString(this.createdDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=MediaTypeEnumDeserializer.class)
    public static enum MediaTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        EMAIL("Email"),
        MESSAGE("Message"),
        VOICE("Voice");

        private String value;

        private MediaTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MediaTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MediaTypeEnum value : MediaTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MediaTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=StateEnumDeserializer.class)
    public static enum StateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        COMPLETED("Completed"),
        VALID("Valid"),
        INVALID("Invalid"),
        FAILED("Failed");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateEnum value : StateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StateEnumDeserializer
    extends StdDeserializer<StateEnum> {
        public StateEnumDeserializer() {
            super(StateEnumDeserializer.class);
        }

        public StateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StateEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class MediaTypeEnumDeserializer
    extends StdDeserializer<MediaTypeEnum> {
        public MediaTypeEnumDeserializer() {
            super(MediaTypeEnumDeserializer.class);
        }

        public MediaTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return MediaTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

