/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.NluDomainVersion;
import java.util.HashMap;
import java.util.Map;

public class PostLanguageunderstandingDomainVersionsRequest {
    private String domainId;
    private NluDomainVersion body;
    private Boolean includeUtterances;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getDomainId() {
        return this.domainId;
    }

    public void setDomainId(String domainId) {
        this.domainId = domainId;
    }

    public PostLanguageunderstandingDomainVersionsRequest withDomainId(String domainId) {
        this.setDomainId(domainId);
        return this;
    }

    public NluDomainVersion getBody() {
        return this.body;
    }

    public void setBody(NluDomainVersion body) {
        this.body = body;
    }

    public PostLanguageunderstandingDomainVersionsRequest withBody(NluDomainVersion body) {
        this.setBody(body);
        return this;
    }

    public Boolean getIncludeUtterances() {
        return this.includeUtterances;
    }

    public void setIncludeUtterances(Boolean includeUtterances) {
        this.includeUtterances = includeUtterances;
    }

    public PostLanguageunderstandingDomainVersionsRequest withIncludeUtterances(Boolean includeUtterances) {
        this.setIncludeUtterances(includeUtterances);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PostLanguageunderstandingDomainVersionsRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<NluDomainVersion> withHttpInfo() {
        if (this.domainId == null) {
            throw new IllegalStateException("Missing the required parameter 'domainId' when building request for PostLanguageunderstandingDomainVersionsRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PostLanguageunderstandingDomainVersionsRequest.");
        }
        return ApiRequestBuilder.create("POST", "/api/v2/languageunderstanding/domains/{domainId}/versions").withPathParameter("domainId", this.domainId).withQueryParameters("includeUtterances", "", this.includeUtterances).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String domainId, NluDomainVersion body) {
        return new Builder().withRequiredParams(domainId, body);
    }

    public static class Builder {
        private final PostLanguageunderstandingDomainVersionsRequest request = new PostLanguageunderstandingDomainVersionsRequest();

        private Builder() {
        }

        public Builder withDomainId(String domainId) {
            this.request.setDomainId(domainId);
            return this;
        }

        public Builder withBody(NluDomainVersion body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withIncludeUtterances(Boolean includeUtterances) {
            this.request.setIncludeUtterances(includeUtterances);
            return this;
        }

        public Builder withRequiredParams(String domainId, NluDomainVersion body) {
            this.request.setDomainId(domainId);
            this.request.setBody(body);
            return this;
        }

        public PostLanguageunderstandingDomainVersionsRequest build() {
            if (this.request.domainId == null) {
                throw new IllegalStateException("Missing the required parameter 'domainId' when building request for PostLanguageunderstandingDomainVersionsRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PostLanguageunderstandingDomainVersionsRequest.");
            }
            return this.request;
        }
    }
}

