/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GetSearchSuggestRequest {
    private String q64;
    private List<String> expand;
    private Boolean profile;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getQ64() {
        return this.q64;
    }

    public void setQ64(String q64) {
        this.q64 = q64;
    }

    public GetSearchSuggestRequest withQ64(String q64) {
        this.setQ64(q64);
        return this;
    }

    public List<String> getExpand() {
        return this.expand;
    }

    public void setExpand(List<String> expand) {
        this.expand = expand;
    }

    public GetSearchSuggestRequest withExpand(List<String> expand) {
        this.setExpand(expand);
        return this;
    }

    public Boolean getProfile() {
        return this.profile;
    }

    public void setProfile(Boolean profile) {
        this.profile = profile;
    }

    public GetSearchSuggestRequest withProfile(Boolean profile) {
        this.setProfile(profile);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetSearchSuggestRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.q64 == null) {
            throw new IllegalStateException("Missing the required parameter 'q64' when building request for GetSearchSuggestRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/search/suggest").withQueryParameters("q64", "", this.q64).withQueryParameters("expand", "multi", this.expand).withQueryParameters("profile", "", this.profile).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String q64) {
        return new Builder().withRequiredParams(q64);
    }

    public static class Builder {
        private final GetSearchSuggestRequest request = new GetSearchSuggestRequest();

        private Builder() {
        }

        public Builder withQ64(String q64) {
            this.request.setQ64(q64);
            return this;
        }

        public Builder withExpand(List<String> expand) {
            this.request.setExpand(expand);
            return this;
        }

        public Builder withExpandEnumValues(List<expandValues> expand) {
            ArrayList<String> stringList = new ArrayList<String>();
            for (expandValues e : expand) {
                stringList.add(e.toString());
            }
            this.request.setExpand(stringList);
            return this;
        }

        public Builder withProfile(Boolean profile) {
            this.request.setProfile(profile);
            return this;
        }

        public Builder withRequiredParams(String q64) {
            this.request.setQ64(q64);
            return this;
        }

        public GetSearchSuggestRequest build() {
            if (this.request.q64 == null) {
                throw new IllegalStateException("Missing the required parameter 'q64' when building request for GetSearchSuggestRequest.");
            }
            return this.request;
        }
    }

    public static enum expandValues {
        ROUTINGSTATUS("routingStatus"),
        PRESENCE("presence"),
        INTEGRATIONPRESENCE("integrationPresence"),
        CONVERSATIONSUMMARY("conversationSummary"),
        OUTOFOFFICE("outOfOffice"),
        GEOLOCATION("geolocation"),
        STATION("station"),
        AUTHORIZATION("authorization"),
        LASTTOKENISSUED("lasttokenissued"),
        DATELASTLOGIN("dateLastLogin"),
        AUTHORIZATION_UNUSEDROLES("authorization.unusedRoles"),
        TEAM("team"),
        PROFILESKILLS("profileSkills"),
        CERTIFICATIONS("certifications"),
        LOCATIONS("locations"),
        GROUPS("groups"),
        SKILLS("skills"),
        LANGUAGES("languages"),
        LANGUAGEPREFERENCE("languagePreference"),
        EMPLOYERINFO("employerInfo"),
        BIOGRAPHY("biography"),
        CALLERUSER_ROUTINGSTATUS("callerUser.routingStatus"),
        CALLERUSER_PRIMARYPRESENCE("callerUser.primaryPresence"),
        CALLERUSER_CONVERSATIONSUMMARY("callerUser.conversationSummary"),
        CALLERUSER_OUTOFOFFICE("callerUser.outOfOffice"),
        CALLERUSER_GEOLOCATION("callerUser.geolocation"),
        IMAGES("images"),
        ADDRESSVERIFICATIONDETAILS("addressVerificationDetails");

        private String value;

        private expandValues(String value) {
            this.value = value;
        }

        @JsonCreator
        public static expandValues fromString(String key) {
            if (key == null) {
                return null;
            }
            for (expandValues value : expandValues.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return expandValues.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

