/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.CoachingNotification;
import java.util.HashMap;
import java.util.Map;

public class PatchCoachingNotificationRequest {
    private String notificationId;
    private CoachingNotification body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getNotificationId() {
        return this.notificationId;
    }

    public void setNotificationId(String notificationId) {
        this.notificationId = notificationId;
    }

    public PatchCoachingNotificationRequest withNotificationId(String notificationId) {
        this.setNotificationId(notificationId);
        return this;
    }

    public CoachingNotification getBody() {
        return this.body;
    }

    public void setBody(CoachingNotification body) {
        this.body = body;
    }

    public PatchCoachingNotificationRequest withBody(CoachingNotification body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PatchCoachingNotificationRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<CoachingNotification> withHttpInfo() {
        if (this.notificationId == null) {
            throw new IllegalStateException("Missing the required parameter 'notificationId' when building request for PatchCoachingNotificationRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchCoachingNotificationRequest.");
        }
        return ApiRequestBuilder.create("PATCH", "/api/v2/coaching/notifications/{notificationId}").withPathParameter("notificationId", this.notificationId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String notificationId, CoachingNotification body) {
        return new Builder().withRequiredParams(notificationId, body);
    }

    public static class Builder {
        private final PatchCoachingNotificationRequest request = new PatchCoachingNotificationRequest();

        private Builder() {
        }

        public Builder withNotificationId(String notificationId) {
            this.request.setNotificationId(notificationId);
            return this;
        }

        public Builder withBody(CoachingNotification body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String notificationId, CoachingNotification body) {
            this.request.setNotificationId(notificationId);
            this.request.setBody(body);
            return this;
        }

        public PatchCoachingNotificationRequest build() {
            if (this.request.notificationId == null) {
                throw new IllegalStateException("Missing the required parameter 'notificationId' when building request for PatchCoachingNotificationRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchCoachingNotificationRequest.");
            }
            return this.request;
        }
    }
}

