/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class GetInfrastructureascodeAcceleratorRequest {
    private String acceleratorId;
    private String preferredLanguage;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getAcceleratorId() {
        return this.acceleratorId;
    }

    public void setAcceleratorId(String acceleratorId) {
        this.acceleratorId = acceleratorId;
    }

    public GetInfrastructureascodeAcceleratorRequest withAcceleratorId(String acceleratorId) {
        this.setAcceleratorId(acceleratorId);
        return this;
    }

    public String getPreferredLanguage() {
        return this.preferredLanguage;
    }

    public void setPreferredLanguage(String preferredLanguage) {
        this.preferredLanguage = preferredLanguage;
    }

    public GetInfrastructureascodeAcceleratorRequest withPreferredLanguage(String preferredLanguage) {
        this.setPreferredLanguage(preferredLanguage);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetInfrastructureascodeAcceleratorRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.acceleratorId == null) {
            throw new IllegalStateException("Missing the required parameter 'acceleratorId' when building request for GetInfrastructureascodeAcceleratorRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/infrastructureascode/accelerators/{acceleratorId}").withPathParameter("acceleratorId", this.acceleratorId).withQueryParameters("preferredLanguage", "", this.preferredLanguage).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String acceleratorId) {
        return new Builder().withRequiredParams(acceleratorId);
    }

    public static class Builder {
        private final GetInfrastructureascodeAcceleratorRequest request = new GetInfrastructureascodeAcceleratorRequest();

        private Builder() {
        }

        public Builder withAcceleratorId(String acceleratorId) {
            this.request.setAcceleratorId(acceleratorId);
            return this;
        }

        public Builder withPreferredLanguage(String preferredLanguage) {
            this.request.setPreferredLanguage(preferredLanguage);
            return this;
        }

        public Builder withPreferredLanguage(preferredLanguageValues preferredLanguage) {
            this.request.setPreferredLanguage(preferredLanguage.toString());
            return this;
        }

        public Builder withRequiredParams(String acceleratorId) {
            this.request.setAcceleratorId(acceleratorId);
            return this;
        }

        public GetInfrastructureascodeAcceleratorRequest build() {
            if (this.request.acceleratorId == null) {
                throw new IllegalStateException("Missing the required parameter 'acceleratorId' when building request for GetInfrastructureascodeAcceleratorRequest.");
            }
            return this.request;
        }
    }

    public static enum preferredLanguageValues {
        AR("ar"),
        CS("cs"),
        DA("da"),
        DE("de"),
        EN_US("en-US"),
        ES("es"),
        FI("fi"),
        FR("fr"),
        IT("it"),
        IW("iw"),
        KO("ko"),
        JA("ja"),
        NL("nl"),
        NO("no"),
        PL("pl"),
        PT_BR("pt-BR"),
        PT_PT("pt-PT"),
        SV("sv"),
        TH("th"),
        TR("tr"),
        ZH_CN("zh-CN"),
        ZH_TW("zh-TW");

        private String value;

        private preferredLanguageValues(String value) {
            this.value = value;
        }

        @JsonCreator
        public static preferredLanguageValues fromString(String key) {
            if (key == null) {
                return null;
            }
            for (preferredLanguageValues value : preferredLanguageValues.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return preferredLanguageValues.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

