/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.api.request.DeleteTeamMembersRequest;
import com.mypurecloud.sdk.v2.api.request.DeleteTeamRequest;
import com.mypurecloud.sdk.v2.api.request.GetTeamMembersRequest;
import com.mypurecloud.sdk.v2.api.request.GetTeamRequest;
import com.mypurecloud.sdk.v2.api.request.GetTeamsRequest;
import com.mypurecloud.sdk.v2.api.request.PatchTeamRequest;
import com.mypurecloud.sdk.v2.api.request.PostAnalyticsTeamsActivityQueryRequest;
import com.mypurecloud.sdk.v2.api.request.PostTeamMembersRequest;
import com.mypurecloud.sdk.v2.api.request.PostTeamsRequest;
import com.mypurecloud.sdk.v2.api.request.PostTeamsSearchRequest;
import com.mypurecloud.sdk.v2.model.Team;
import com.mypurecloud.sdk.v2.model.TeamActivityQuery;
import com.mypurecloud.sdk.v2.model.TeamActivityResponse;
import com.mypurecloud.sdk.v2.model.TeamEntityListing;
import com.mypurecloud.sdk.v2.model.TeamMemberAddListingResponse;
import com.mypurecloud.sdk.v2.model.TeamMemberEntityListing;
import com.mypurecloud.sdk.v2.model.TeamMembers;
import com.mypurecloud.sdk.v2.model.TeamSearchRequest;
import com.mypurecloud.sdk.v2.model.TeamsSearchResponse;
import java.io.IOException;

public class TeamsApi {
    private final ApiClient pcapiClient;

    public TeamsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public TeamsApi(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public void deleteTeam(String teamId) throws IOException, ApiException {
        this.deleteTeam(this.createDeleteTeamRequest(teamId));
    }

    public ApiResponse<Void> deleteTeamWithHttpInfo(String teamId) throws IOException {
        return this.deleteTeam(this.createDeleteTeamRequest(teamId).withHttpInfo());
    }

    private DeleteTeamRequest createDeleteTeamRequest(String teamId) {
        return DeleteTeamRequest.builder().withTeamId(teamId).build();
    }

    public void deleteTeam(DeleteTeamRequest request) throws IOException, ApiException {
        block2: {
            try {
                ApiResponse apiResponse = this.pcapiClient.invoke(request.withHttpInfo(), null);
            }
            catch (ApiException | IOException exception) {
                if (!this.pcapiClient.getShouldThrowErrors()) break block2;
                throw exception;
            }
        }
    }

    public ApiResponse<Void> deleteTeam(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, null);
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public void deleteTeamMembers(String teamId, String id) throws IOException, ApiException {
        this.deleteTeamMembers(this.createDeleteTeamMembersRequest(teamId, id));
    }

    public ApiResponse<Void> deleteTeamMembersWithHttpInfo(String teamId, String id) throws IOException {
        return this.deleteTeamMembers(this.createDeleteTeamMembersRequest(teamId, id).withHttpInfo());
    }

    private DeleteTeamMembersRequest createDeleteTeamMembersRequest(String teamId, String id) {
        return DeleteTeamMembersRequest.builder().withTeamId(teamId).withId(id).build();
    }

    public void deleteTeamMembers(DeleteTeamMembersRequest request) throws IOException, ApiException {
        block2: {
            try {
                ApiResponse apiResponse = this.pcapiClient.invoke(request.withHttpInfo(), null);
            }
            catch (ApiException | IOException exception) {
                if (!this.pcapiClient.getShouldThrowErrors()) break block2;
                throw exception;
            }
        }
    }

    public ApiResponse<Void> deleteTeamMembers(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, null);
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public Team getTeam(String teamId) throws IOException, ApiException {
        return this.getTeam(this.createGetTeamRequest(teamId));
    }

    public ApiResponse<Team> getTeamWithHttpInfo(String teamId) throws IOException {
        return this.getTeam(this.createGetTeamRequest(teamId).withHttpInfo());
    }

    private GetTeamRequest createGetTeamRequest(String teamId) {
        return GetTeamRequest.builder().withTeamId(teamId).build();
    }

    public Team getTeam(GetTeamRequest request) throws IOException, ApiException {
        try {
            ApiResponse<Team> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<Team>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<Team> getTeam(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<Team>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public TeamMemberEntityListing getTeamMembers(String teamId, Integer pageSize, String before, String after, String expand) throws IOException, ApiException {
        return this.getTeamMembers(this.createGetTeamMembersRequest(teamId, pageSize, before, after, expand));
    }

    public ApiResponse<TeamMemberEntityListing> getTeamMembersWithHttpInfo(String teamId, Integer pageSize, String before, String after, String expand) throws IOException {
        return this.getTeamMembers(this.createGetTeamMembersRequest(teamId, pageSize, before, after, expand).withHttpInfo());
    }

    private GetTeamMembersRequest createGetTeamMembersRequest(String teamId, Integer pageSize, String before, String after, String expand) {
        return GetTeamMembersRequest.builder().withTeamId(teamId).withPageSize(pageSize).withBefore(before).withAfter(after).withExpand(expand).build();
    }

    public TeamMemberEntityListing getTeamMembers(GetTeamMembersRequest request) throws IOException, ApiException {
        try {
            ApiResponse<TeamMemberEntityListing> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<TeamMemberEntityListing>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<TeamMemberEntityListing> getTeamMembers(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<TeamMemberEntityListing>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public TeamEntityListing getTeams(Integer pageSize, String name, String after, String before, String expand) throws IOException, ApiException {
        return this.getTeams(this.createGetTeamsRequest(pageSize, name, after, before, expand));
    }

    public ApiResponse<TeamEntityListing> getTeamsWithHttpInfo(Integer pageSize, String name, String after, String before, String expand) throws IOException {
        return this.getTeams(this.createGetTeamsRequest(pageSize, name, after, before, expand).withHttpInfo());
    }

    private GetTeamsRequest createGetTeamsRequest(Integer pageSize, String name, String after, String before, String expand) {
        return GetTeamsRequest.builder().withPageSize(pageSize).withName(name).withAfter(after).withBefore(before).withExpand(expand).build();
    }

    public TeamEntityListing getTeams(GetTeamsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<TeamEntityListing> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<TeamEntityListing>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<TeamEntityListing> getTeams(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<TeamEntityListing>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public Team patchTeam(String teamId, Team body) throws IOException, ApiException {
        return this.patchTeam(this.createPatchTeamRequest(teamId, body));
    }

    public ApiResponse<Team> patchTeamWithHttpInfo(String teamId, Team body) throws IOException {
        return this.patchTeam(this.createPatchTeamRequest(teamId, body).withHttpInfo());
    }

    private PatchTeamRequest createPatchTeamRequest(String teamId, Team body) {
        return PatchTeamRequest.builder().withTeamId(teamId).withBody(body).build();
    }

    public Team patchTeam(PatchTeamRequest request) throws IOException, ApiException {
        try {
            ApiResponse<Team> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<Team>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<Team> patchTeam(ApiRequest<Team> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<Team>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public TeamActivityResponse postAnalyticsTeamsActivityQuery(TeamActivityQuery body, Integer pageSize, Integer pageNumber) throws IOException, ApiException {
        return this.postAnalyticsTeamsActivityQuery(this.createPostAnalyticsTeamsActivityQueryRequest(body, pageSize, pageNumber));
    }

    public ApiResponse<TeamActivityResponse> postAnalyticsTeamsActivityQueryWithHttpInfo(TeamActivityQuery body, Integer pageSize, Integer pageNumber) throws IOException {
        return this.postAnalyticsTeamsActivityQuery(this.createPostAnalyticsTeamsActivityQueryRequest(body, pageSize, pageNumber).withHttpInfo());
    }

    private PostAnalyticsTeamsActivityQueryRequest createPostAnalyticsTeamsActivityQueryRequest(TeamActivityQuery body, Integer pageSize, Integer pageNumber) {
        return PostAnalyticsTeamsActivityQueryRequest.builder().withBody(body).withPageSize(pageSize).withPageNumber(pageNumber).build();
    }

    public TeamActivityResponse postAnalyticsTeamsActivityQuery(PostAnalyticsTeamsActivityQueryRequest request) throws IOException, ApiException {
        try {
            ApiResponse<TeamActivityResponse> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<TeamActivityResponse>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<TeamActivityResponse> postAnalyticsTeamsActivityQuery(ApiRequest<TeamActivityQuery> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<TeamActivityResponse>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public TeamMemberAddListingResponse postTeamMembers(String teamId, TeamMembers body) throws IOException, ApiException {
        return this.postTeamMembers(this.createPostTeamMembersRequest(teamId, body));
    }

    public ApiResponse<TeamMemberAddListingResponse> postTeamMembersWithHttpInfo(String teamId, TeamMembers body) throws IOException {
        return this.postTeamMembers(this.createPostTeamMembersRequest(teamId, body).withHttpInfo());
    }

    private PostTeamMembersRequest createPostTeamMembersRequest(String teamId, TeamMembers body) {
        return PostTeamMembersRequest.builder().withTeamId(teamId).withBody(body).build();
    }

    public TeamMemberAddListingResponse postTeamMembers(PostTeamMembersRequest request) throws IOException, ApiException {
        try {
            ApiResponse<TeamMemberAddListingResponse> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<TeamMemberAddListingResponse>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<TeamMemberAddListingResponse> postTeamMembers(ApiRequest<TeamMembers> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<TeamMemberAddListingResponse>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public Team postTeams(Team body) throws IOException, ApiException {
        return this.postTeams(this.createPostTeamsRequest(body));
    }

    public ApiResponse<Team> postTeamsWithHttpInfo(Team body) throws IOException {
        return this.postTeams(this.createPostTeamsRequest(body).withHttpInfo());
    }

    private PostTeamsRequest createPostTeamsRequest(Team body) {
        return PostTeamsRequest.builder().withBody(body).build();
    }

    public Team postTeams(PostTeamsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<Team> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<Team>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<Team> postTeams(ApiRequest<Team> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<Team>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public TeamsSearchResponse postTeamsSearch(TeamSearchRequest body) throws IOException, ApiException {
        return this.postTeamsSearch(this.createPostTeamsSearchRequest(body));
    }

    public ApiResponse<TeamsSearchResponse> postTeamsSearchWithHttpInfo(TeamSearchRequest body) throws IOException {
        return this.postTeamsSearch(this.createPostTeamsSearchRequest(body).withHttpInfo());
    }

    private PostTeamsSearchRequest createPostTeamsSearchRequest(TeamSearchRequest body) {
        return PostTeamsSearchRequest.builder().withBody(body).build();
    }

    public TeamsSearchResponse postTeamsSearch(PostTeamsSearchRequest request) throws IOException, ApiException {
        try {
            ApiResponse<TeamsSearchResponse> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<TeamsSearchResponse>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<TeamsSearchResponse> postTeamsSearch(ApiRequest<TeamSearchRequest> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<TeamsSearchResponse>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }
}

