/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.PatchCallToAction;
import com.mypurecloud.sdk.v2.model.PatchContentOfferStylingConfiguration;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class PatchContentOffer
implements Serializable {
    private String imageUrl = null;
    private DisplayModeEnum displayMode = null;
    private LayoutModeEnum layoutMode = null;
    private String title = null;
    private String headline = null;
    private String body = null;
    private PatchCallToAction callToAction = null;
    private PatchContentOfferStylingConfiguration style = null;

    public PatchContentOffer imageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
        return this;
    }

    @ApiModelProperty(example="null", value="URL for image displayed to the customer when displaying content offer.")
    @JsonProperty(value="imageUrl")
    public String getImageUrl() {
        return this.imageUrl;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public PatchContentOffer displayMode(DisplayModeEnum displayMode) {
        this.displayMode = displayMode;
        return this;
    }

    @ApiModelProperty(example="null", value="The display mode of Genesys Widgets when displaying content offer.")
    @JsonProperty(value="displayMode")
    public DisplayModeEnum getDisplayMode() {
        return this.displayMode;
    }

    public void setDisplayMode(DisplayModeEnum displayMode) {
        this.displayMode = displayMode;
    }

    public PatchContentOffer layoutMode(LayoutModeEnum layoutMode) {
        this.layoutMode = layoutMode;
        return this;
    }

    @ApiModelProperty(example="null", value="The layout mode of the text shown to the user when displaying content offer.")
    @JsonProperty(value="layoutMode")
    public LayoutModeEnum getLayoutMode() {
        return this.layoutMode;
    }

    public void setLayoutMode(LayoutModeEnum layoutMode) {
        this.layoutMode = layoutMode;
    }

    public PatchContentOffer title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(example="null", value="Title used in the header of the content offer.")
    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public PatchContentOffer headline(String headline) {
        this.headline = headline;
        return this;
    }

    @ApiModelProperty(example="null", value="Headline displayed above the body text of the content offer.")
    @JsonProperty(value="headline")
    public String getHeadline() {
        return this.headline;
    }

    public void setHeadline(String headline) {
        this.headline = headline;
    }

    public PatchContentOffer body(String body) {
        this.body = body;
        return this;
    }

    @ApiModelProperty(example="null", value="Body text of the content offer.")
    @JsonProperty(value="body")
    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public PatchContentOffer callToAction(PatchCallToAction callToAction) {
        this.callToAction = callToAction;
        return this;
    }

    @ApiModelProperty(example="null", value="Properties customizing the call to action button on the content offer.")
    @JsonProperty(value="callToAction")
    public PatchCallToAction getCallToAction() {
        return this.callToAction;
    }

    public void setCallToAction(PatchCallToAction callToAction) {
        this.callToAction = callToAction;
    }

    public PatchContentOffer style(PatchContentOfferStylingConfiguration style) {
        this.style = style;
        return this;
    }

    @ApiModelProperty(example="null", value="Properties customizing the styling of the content offer.")
    @JsonProperty(value="style")
    public PatchContentOfferStylingConfiguration getStyle() {
        return this.style;
    }

    public void setStyle(PatchContentOfferStylingConfiguration style) {
        this.style = style;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PatchContentOffer patchContentOffer = (PatchContentOffer)o;
        return Objects.equals(this.imageUrl, patchContentOffer.imageUrl) && Objects.equals((Object)this.displayMode, (Object)patchContentOffer.displayMode) && Objects.equals((Object)this.layoutMode, (Object)patchContentOffer.layoutMode) && Objects.equals(this.title, patchContentOffer.title) && Objects.equals(this.headline, patchContentOffer.headline) && Objects.equals(this.body, patchContentOffer.body) && Objects.equals(this.callToAction, patchContentOffer.callToAction) && Objects.equals(this.style, patchContentOffer.style);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.imageUrl, this.displayMode, this.layoutMode, this.title, this.headline, this.body, this.callToAction, this.style});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PatchContentOffer {\n");
        sb.append("    imageUrl: ").append(this.toIndentedString(this.imageUrl)).append("\n");
        sb.append("    displayMode: ").append(this.toIndentedString((Object)this.displayMode)).append("\n");
        sb.append("    layoutMode: ").append(this.toIndentedString((Object)this.layoutMode)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    headline: ").append(this.toIndentedString(this.headline)).append("\n");
        sb.append("    body: ").append(this.toIndentedString(this.body)).append("\n");
        sb.append("    callToAction: ").append(this.toIndentedString(this.callToAction)).append("\n");
        sb.append("    style: ").append(this.toIndentedString(this.style)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=LayoutModeEnumDeserializer.class)
    public static enum LayoutModeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        TEXTONLY("TextOnly"),
        IMAGEONLY("ImageOnly"),
        LEFTTEXT("LeftText"),
        RIGHTTEXT("RightText"),
        TOPTEXT("TopText"),
        BOTTOMTEXT("BottomText");

        private String value;

        private LayoutModeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static LayoutModeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (LayoutModeEnum value : LayoutModeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return LayoutModeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class LayoutModeEnumDeserializer
    extends StdDeserializer<LayoutModeEnum> {
        public LayoutModeEnumDeserializer() {
            super(LayoutModeEnumDeserializer.class);
        }

        public LayoutModeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return LayoutModeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=DisplayModeEnumDeserializer.class)
    public static enum DisplayModeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        MODAL("Modal"),
        OVERLAY("Overlay"),
        TOAST("Toast");

        private String value;

        private DisplayModeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DisplayModeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (DisplayModeEnum value : DisplayModeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return DisplayModeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class DisplayModeEnumDeserializer
    extends StdDeserializer<DisplayModeEnum> {
        public DisplayModeEnumDeserializer() {
            super(DisplayModeEnumDeserializer.class);
        }

        public DisplayModeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return DisplayModeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

