/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.DigitalAction;
import com.mypurecloud.sdk.v2.model.DigitalCondition;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class DigitalRule
implements Serializable {
    private String id = null;
    private String name = null;
    private Integer order = null;
    private CategoryEnum category = null;
    private List<DigitalCondition> conditions = new ArrayList<DigitalCondition>();
    private List<DigitalAction> actions = new ArrayList<DigitalAction>();

    @ApiModelProperty(example="null", value="The identifier of the rule.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public DigitalRule name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of the rule.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DigitalRule order(Integer order) {
        this.order = order;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The ranked order of the rule. Rules are processed from lowest number to highest.")
    @JsonProperty(value="order")
    public Integer getOrder() {
        return this.order;
    }

    public void setOrder(Integer order) {
        this.order = order;
    }

    public DigitalRule category(CategoryEnum category) {
        this.category = category;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The category of the rule.")
    @JsonProperty(value="category")
    public CategoryEnum getCategory() {
        return this.category;
    }

    public void setCategory(CategoryEnum category) {
        this.category = category;
    }

    public DigitalRule conditions(List<DigitalCondition> conditions) {
        this.conditions = conditions;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="A list of conditions to evaluate. All of the Conditions must evaluate to true to trigger the actions.")
    @JsonProperty(value="conditions")
    public List<DigitalCondition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<DigitalCondition> conditions) {
        this.conditions = conditions;
    }

    public DigitalRule actions(List<DigitalAction> actions) {
        this.actions = actions;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The list of actions to be taken if all conditions are true.")
    @JsonProperty(value="actions")
    public List<DigitalAction> getActions() {
        return this.actions;
    }

    public void setActions(List<DigitalAction> actions) {
        this.actions = actions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DigitalRule digitalRule = (DigitalRule)o;
        return Objects.equals(this.id, digitalRule.id) && Objects.equals(this.name, digitalRule.name) && Objects.equals(this.order, digitalRule.order) && Objects.equals((Object)this.category, (Object)digitalRule.category) && Objects.equals(this.conditions, digitalRule.conditions) && Objects.equals(this.actions, digitalRule.actions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.order, this.category, this.conditions, this.actions});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DigitalRule {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    order: ").append(this.toIndentedString(this.order)).append("\n");
        sb.append("    category: ").append(this.toIndentedString((Object)this.category)).append("\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("    actions: ").append(this.toIndentedString(this.actions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=CategoryEnumDeserializer.class)
    public static enum CategoryEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        PRECONTACT("PreContact"),
        POSTCONTACT("PostContact");

        private String value;

        private CategoryEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static CategoryEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (CategoryEnum value : CategoryEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return CategoryEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class CategoryEnumDeserializer
    extends StdDeserializer<CategoryEnum> {
        public CategoryEnumDeserializer() {
            super(CategoryEnumDeserializer.class);
        }

        public CategoryEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return CategoryEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

