/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.api.request.DeleteAuthorizationDivisionRequest;
import com.mypurecloud.sdk.v2.api.request.GetAuthorizationDivisionRequest;
import com.mypurecloud.sdk.v2.api.request.GetAuthorizationDivisionsHomeRequest;
import com.mypurecloud.sdk.v2.api.request.GetAuthorizationDivisionsLimitRequest;
import com.mypurecloud.sdk.v2.api.request.GetAuthorizationDivisionsRequest;
import com.mypurecloud.sdk.v2.api.request.PostAuthorizationDivisionObjectRequest;
import com.mypurecloud.sdk.v2.api.request.PostAuthorizationDivisionRestoreRequest;
import com.mypurecloud.sdk.v2.api.request.PostAuthorizationDivisionsRequest;
import com.mypurecloud.sdk.v2.api.request.PutAuthorizationDivisionRequest;
import com.mypurecloud.sdk.v2.model.AuthzDivision;
import com.mypurecloud.sdk.v2.model.AuthzDivisionEntityListing;
import java.io.IOException;
import java.util.List;

public class ObjectsApi {
    private final ApiClient pcapiClient;

    public ObjectsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ObjectsApi(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public void deleteAuthorizationDivision(String divisionId, Boolean force) throws IOException, ApiException {
        this.deleteAuthorizationDivision(this.createDeleteAuthorizationDivisionRequest(divisionId, force));
    }

    public ApiResponse<Void> deleteAuthorizationDivisionWithHttpInfo(String divisionId, Boolean force) throws IOException {
        return this.deleteAuthorizationDivision(this.createDeleteAuthorizationDivisionRequest(divisionId, force).withHttpInfo());
    }

    private DeleteAuthorizationDivisionRequest createDeleteAuthorizationDivisionRequest(String divisionId, Boolean force) {
        return DeleteAuthorizationDivisionRequest.builder().withDivisionId(divisionId).withForce(force).build();
    }

    public void deleteAuthorizationDivision(DeleteAuthorizationDivisionRequest request) throws IOException, ApiException {
        block2: {
            try {
                ApiResponse apiResponse = this.pcapiClient.invoke(request.withHttpInfo(), null);
            }
            catch (ApiException | IOException exception) {
                if (!this.pcapiClient.getShouldThrowErrors()) break block2;
                throw exception;
            }
        }
    }

    public ApiResponse<Void> deleteAuthorizationDivision(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, null);
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public AuthzDivision getAuthorizationDivision(String divisionId, Boolean objectCount) throws IOException, ApiException {
        return this.getAuthorizationDivision(this.createGetAuthorizationDivisionRequest(divisionId, objectCount));
    }

    public ApiResponse<AuthzDivision> getAuthorizationDivisionWithHttpInfo(String divisionId, Boolean objectCount) throws IOException {
        return this.getAuthorizationDivision(this.createGetAuthorizationDivisionRequest(divisionId, objectCount).withHttpInfo());
    }

    private GetAuthorizationDivisionRequest createGetAuthorizationDivisionRequest(String divisionId, Boolean objectCount) {
        return GetAuthorizationDivisionRequest.builder().withDivisionId(divisionId).withObjectCount(objectCount).build();
    }

    public AuthzDivision getAuthorizationDivision(GetAuthorizationDivisionRequest request) throws IOException, ApiException {
        try {
            ApiResponse<AuthzDivision> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<AuthzDivision>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<AuthzDivision> getAuthorizationDivision(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<AuthzDivision>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public AuthzDivisionEntityListing getAuthorizationDivisions(Integer pageSize, Integer pageNumber, String sortBy, List<String> expand, String nextPage, String previousPage, Boolean objectCount, List<String> id, String name) throws IOException, ApiException {
        return this.getAuthorizationDivisions(this.createGetAuthorizationDivisionsRequest(pageSize, pageNumber, sortBy, expand, nextPage, previousPage, objectCount, id, name));
    }

    public ApiResponse<AuthzDivisionEntityListing> getAuthorizationDivisionsWithHttpInfo(Integer pageSize, Integer pageNumber, String sortBy, List<String> expand, String nextPage, String previousPage, Boolean objectCount, List<String> id, String name) throws IOException {
        return this.getAuthorizationDivisions(this.createGetAuthorizationDivisionsRequest(pageSize, pageNumber, sortBy, expand, nextPage, previousPage, objectCount, id, name).withHttpInfo());
    }

    private GetAuthorizationDivisionsRequest createGetAuthorizationDivisionsRequest(Integer pageSize, Integer pageNumber, String sortBy, List<String> expand, String nextPage, String previousPage, Boolean objectCount, List<String> id, String name) {
        return GetAuthorizationDivisionsRequest.builder().withPageSize(pageSize).withPageNumber(pageNumber).withSortBy(sortBy).withExpand(expand).withNextPage(nextPage).withPreviousPage(previousPage).withObjectCount(objectCount).withId(id).withName(name).build();
    }

    public AuthzDivisionEntityListing getAuthorizationDivisions(GetAuthorizationDivisionsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<AuthzDivisionEntityListing> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<AuthzDivisionEntityListing>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<AuthzDivisionEntityListing> getAuthorizationDivisions(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<AuthzDivisionEntityListing>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public AuthzDivision getAuthorizationDivisionsHome() throws IOException, ApiException {
        return this.getAuthorizationDivisionsHome(this.createGetAuthorizationDivisionsHomeRequest());
    }

    public ApiResponse<AuthzDivision> getAuthorizationDivisionsHomeWithHttpInfo() throws IOException {
        return this.getAuthorizationDivisionsHome(this.createGetAuthorizationDivisionsHomeRequest().withHttpInfo());
    }

    private GetAuthorizationDivisionsHomeRequest createGetAuthorizationDivisionsHomeRequest() {
        return GetAuthorizationDivisionsHomeRequest.builder().build();
    }

    public AuthzDivision getAuthorizationDivisionsHome(GetAuthorizationDivisionsHomeRequest request) throws IOException, ApiException {
        try {
            ApiResponse<AuthzDivision> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<AuthzDivision>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<AuthzDivision> getAuthorizationDivisionsHome(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<AuthzDivision>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public Integer getAuthorizationDivisionsLimit() throws IOException, ApiException {
        return this.getAuthorizationDivisionsLimit(this.createGetAuthorizationDivisionsLimitRequest());
    }

    public ApiResponse<Integer> getAuthorizationDivisionsLimitWithHttpInfo() throws IOException {
        return this.getAuthorizationDivisionsLimit(this.createGetAuthorizationDivisionsLimitRequest().withHttpInfo());
    }

    private GetAuthorizationDivisionsLimitRequest createGetAuthorizationDivisionsLimitRequest() {
        return GetAuthorizationDivisionsLimitRequest.builder().build();
    }

    public Integer getAuthorizationDivisionsLimit(GetAuthorizationDivisionsLimitRequest request) throws IOException, ApiException {
        try {
            ApiResponse<Integer> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<Integer>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<Integer> getAuthorizationDivisionsLimit(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<Integer>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public void postAuthorizationDivisionObject(String divisionId, String objectType, List<String> body) throws IOException, ApiException {
        this.postAuthorizationDivisionObject(this.createPostAuthorizationDivisionObjectRequest(divisionId, objectType, body));
    }

    public ApiResponse<Void> postAuthorizationDivisionObjectWithHttpInfo(String divisionId, String objectType, List<String> body) throws IOException {
        return this.postAuthorizationDivisionObject(this.createPostAuthorizationDivisionObjectRequest(divisionId, objectType, body).withHttpInfo());
    }

    private PostAuthorizationDivisionObjectRequest createPostAuthorizationDivisionObjectRequest(String divisionId, String objectType, List<String> body) {
        return PostAuthorizationDivisionObjectRequest.builder().withDivisionId(divisionId).withObjectType(objectType).withBody(body).build();
    }

    public void postAuthorizationDivisionObject(PostAuthorizationDivisionObjectRequest request) throws IOException, ApiException {
        block2: {
            try {
                ApiResponse apiResponse = this.pcapiClient.invoke(request.withHttpInfo(), null);
            }
            catch (ApiException | IOException exception) {
                if (!this.pcapiClient.getShouldThrowErrors()) break block2;
                throw exception;
            }
        }
    }

    public ApiResponse<Void> postAuthorizationDivisionObject(ApiRequest<List<String>> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, null);
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public AuthzDivision postAuthorizationDivisionRestore(String divisionId, AuthzDivision body) throws IOException, ApiException {
        return this.postAuthorizationDivisionRestore(this.createPostAuthorizationDivisionRestoreRequest(divisionId, body));
    }

    public ApiResponse<AuthzDivision> postAuthorizationDivisionRestoreWithHttpInfo(String divisionId, AuthzDivision body) throws IOException {
        return this.postAuthorizationDivisionRestore(this.createPostAuthorizationDivisionRestoreRequest(divisionId, body).withHttpInfo());
    }

    private PostAuthorizationDivisionRestoreRequest createPostAuthorizationDivisionRestoreRequest(String divisionId, AuthzDivision body) {
        return PostAuthorizationDivisionRestoreRequest.builder().withDivisionId(divisionId).withBody(body).build();
    }

    public AuthzDivision postAuthorizationDivisionRestore(PostAuthorizationDivisionRestoreRequest request) throws IOException, ApiException {
        try {
            ApiResponse<AuthzDivision> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<AuthzDivision>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<AuthzDivision> postAuthorizationDivisionRestore(ApiRequest<AuthzDivision> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<AuthzDivision>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public AuthzDivision postAuthorizationDivisions(AuthzDivision body) throws IOException, ApiException {
        return this.postAuthorizationDivisions(this.createPostAuthorizationDivisionsRequest(body));
    }

    public ApiResponse<AuthzDivision> postAuthorizationDivisionsWithHttpInfo(AuthzDivision body) throws IOException {
        return this.postAuthorizationDivisions(this.createPostAuthorizationDivisionsRequest(body).withHttpInfo());
    }

    private PostAuthorizationDivisionsRequest createPostAuthorizationDivisionsRequest(AuthzDivision body) {
        return PostAuthorizationDivisionsRequest.builder().withBody(body).build();
    }

    public AuthzDivision postAuthorizationDivisions(PostAuthorizationDivisionsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<AuthzDivision> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<AuthzDivision>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<AuthzDivision> postAuthorizationDivisions(ApiRequest<AuthzDivision> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<AuthzDivision>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public AuthzDivision putAuthorizationDivision(String divisionId, AuthzDivision body) throws IOException, ApiException {
        return this.putAuthorizationDivision(this.createPutAuthorizationDivisionRequest(divisionId, body));
    }

    public ApiResponse<AuthzDivision> putAuthorizationDivisionWithHttpInfo(String divisionId, AuthzDivision body) throws IOException {
        return this.putAuthorizationDivision(this.createPutAuthorizationDivisionRequest(divisionId, body).withHttpInfo());
    }

    private PutAuthorizationDivisionRequest createPutAuthorizationDivisionRequest(String divisionId, AuthzDivision body) {
        return PutAuthorizationDivisionRequest.builder().withDivisionId(divisionId).withBody(body).build();
    }

    public AuthzDivision putAuthorizationDivision(PutAuthorizationDivisionRequest request) throws IOException, ApiException {
        try {
            ApiResponse<AuthzDivision> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<AuthzDivision>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<AuthzDivision> putAuthorizationDivision(ApiRequest<AuthzDivision> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<AuthzDivision>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }
}

