/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.LearningModuleRule;
import java.util.HashMap;
import java.util.Map;

public class PutLearningModuleRuleRequest {
    private String moduleId;
    private LearningModuleRule body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getModuleId() {
        return this.moduleId;
    }

    public void setModuleId(String moduleId) {
        this.moduleId = moduleId;
    }

    public PutLearningModuleRuleRequest withModuleId(String moduleId) {
        this.setModuleId(moduleId);
        return this;
    }

    public LearningModuleRule getBody() {
        return this.body;
    }

    public void setBody(LearningModuleRule body) {
        this.body = body;
    }

    public PutLearningModuleRuleRequest withBody(LearningModuleRule body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PutLearningModuleRuleRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<LearningModuleRule> withHttpInfo() {
        if (this.moduleId == null) {
            throw new IllegalStateException("Missing the required parameter 'moduleId' when building request for PutLearningModuleRuleRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PutLearningModuleRuleRequest.");
        }
        return ApiRequestBuilder.create("PUT", "/api/v2/learning/modules/{moduleId}/rule").withPathParameter("moduleId", this.moduleId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String moduleId, LearningModuleRule body) {
        return new Builder().withRequiredParams(moduleId, body);
    }

    public static class Builder {
        private final PutLearningModuleRuleRequest request = new PutLearningModuleRuleRequest();

        private Builder() {
        }

        public Builder withModuleId(String moduleId) {
            this.request.setModuleId(moduleId);
            return this;
        }

        public Builder withBody(LearningModuleRule body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String moduleId, LearningModuleRule body) {
            this.request.setModuleId(moduleId);
            this.request.setBody(body);
            return this;
        }

        public PutLearningModuleRuleRequest build() {
            if (this.request.moduleId == null) {
                throw new IllegalStateException("Missing the required parameter 'moduleId' when building request for PutLearningModuleRuleRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PutLearningModuleRuleRequest.");
            }
            return this.request;
        }
    }
}

