/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.UserRoutingStatusUserParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Error information that the Public API will receive in a response body. This allows backend services to pass an error message to consumers of the Public API.")
public class UserRoutingStatusErrorInfo
implements Serializable {
    private String errorCode = null;
    private Integer status = null;
    private String correlationId = null;
    private String userMessage = null;
    private String userParamsMessage = null;
    private List<UserRoutingStatusUserParam> userParams = new ArrayList<UserRoutingStatusUserParam>();

    public UserRoutingStatusErrorInfo errorCode(String errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    @ApiModelProperty(example="null", value="A code unique to this error. Typically prefixed with the service that originated the error. For example CONFIG_USER_NOT_FOUND")
    @JsonProperty(value="errorCode")
    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public UserRoutingStatusErrorInfo status(Integer status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="null", value="The HTTP status code for this message. If left blank the status code from the HTTP response is used.")
    @JsonProperty(value="status")
    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public UserRoutingStatusErrorInfo correlationId(String correlationId) {
        this.correlationId = correlationId;
        return this;
    }

    @ApiModelProperty(example="null", value="The correlation Id or context Id for this message. If left blank the Public API will look at the HTTP response header 'ININ-Correlation-Id' instead.")
    @JsonProperty(value="correlationId")
    public String getCorrelationId() {
        return this.correlationId;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public UserRoutingStatusErrorInfo userMessage(String userMessage) {
        this.userMessage = userMessage;
        return this;
    }

    @ApiModelProperty(example="null", value="A customer friendly message. This should be a complete sentence, use proper grammar and only include information useful to a customer. This is not a dev message and should not include things like Org Id")
    @JsonProperty(value="userMessage")
    public String getUserMessage() {
        return this.userMessage;
    }

    public void setUserMessage(String userMessage) {
        this.userMessage = userMessage;
    }

    public UserRoutingStatusErrorInfo userParamsMessage(String userParamsMessage) {
        this.userParamsMessage = userParamsMessage;
        return this;
    }

    @ApiModelProperty(example="null", value="This is the same as userMessage except it uses template fields for variable replacement. For instance: 'User {username} was not found'")
    @JsonProperty(value="userParamsMessage")
    public String getUserParamsMessage() {
        return this.userParamsMessage;
    }

    public void setUserParamsMessage(String userParamsMessage) {
        this.userParamsMessage = userParamsMessage;
    }

    public UserRoutingStatusErrorInfo userParams(List<UserRoutingStatusUserParam> userParams) {
        this.userParams = userParams;
        return this;
    }

    @ApiModelProperty(example="null", value="Used in conjunction with userParamsMessage. These are the template parameters. For instance: UserParam.key = 'username', UserParam.value = 'chuck.pulfer'")
    @JsonProperty(value="userParams")
    public List<UserRoutingStatusUserParam> getUserParams() {
        return this.userParams;
    }

    public void setUserParams(List<UserRoutingStatusUserParam> userParams) {
        this.userParams = userParams;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserRoutingStatusErrorInfo userRoutingStatusErrorInfo = (UserRoutingStatusErrorInfo)o;
        return Objects.equals(this.errorCode, userRoutingStatusErrorInfo.errorCode) && Objects.equals(this.status, userRoutingStatusErrorInfo.status) && Objects.equals(this.correlationId, userRoutingStatusErrorInfo.correlationId) && Objects.equals(this.userMessage, userRoutingStatusErrorInfo.userMessage) && Objects.equals(this.userParamsMessage, userRoutingStatusErrorInfo.userParamsMessage) && Objects.equals(this.userParams, userRoutingStatusErrorInfo.userParams);
    }

    public int hashCode() {
        return Objects.hash(this.errorCode, this.status, this.correlationId, this.userMessage, this.userParamsMessage, this.userParams);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserRoutingStatusErrorInfo {\n");
        sb.append("    errorCode: ").append(this.toIndentedString(this.errorCode)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    correlationId: ").append(this.toIndentedString(this.correlationId)).append("\n");
        sb.append("    userMessage: ").append(this.toIndentedString(this.userMessage)).append("\n");
        sb.append("    userParamsMessage: ").append(this.toIndentedString(this.userParamsMessage)).append("\n");
        sb.append("    userParams: ").append(this.toIndentedString(this.userParams)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

