/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.ActionMapAction;
import com.mypurecloud.sdk.v2.model.ActionMapScheduleGroups;
import com.mypurecloud.sdk.v2.model.Activation;
import com.mypurecloud.sdk.v2.model.EventCondition;
import com.mypurecloud.sdk.v2.model.OutcomeProbabilityCondition;
import com.mypurecloud.sdk.v2.model.UrlCondition;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class ActionMap
implements Serializable {
    private String id = null;
    private Integer version = null;
    private Boolean isActive = null;
    private String displayName = null;
    private List<String> triggerWithSegments = new ArrayList<String>();
    private List<EventCondition> triggerWithEventConditions = new ArrayList<EventCondition>();
    private List<OutcomeProbabilityCondition> triggerWithOutcomeProbabilityConditions = new ArrayList<OutcomeProbabilityCondition>();
    private List<UrlCondition> pageUrlConditions = new ArrayList<UrlCondition>();
    private Activation activation = null;
    private Integer weight = null;
    private ActionMapAction action = null;
    private ActionMapScheduleGroups actionMapScheduleGroups = null;
    private Boolean ignoreFrequencyCap = null;
    private String selfUri = null;
    private Date createdDate = null;
    private Date modifiedDate = null;
    private Date startDate = null;
    private Date endDate = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public ActionMap version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(example="null", value="The version of the action map.")
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public ActionMap isActive(Boolean isActive) {
        this.isActive = isActive;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether the action map is active.")
    @JsonProperty(value="isActive")
    public Boolean getIsActive() {
        return this.isActive;
    }

    public void setIsActive(Boolean isActive) {
        this.isActive = isActive;
    }

    public ActionMap displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Display name of the action map.")
    @JsonProperty(value="displayName")
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public ActionMap triggerWithSegments(List<String> triggerWithSegments) {
        this.triggerWithSegments = triggerWithSegments;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Trigger action map if any segment in the list is assigned to a given customer.")
    @JsonProperty(value="triggerWithSegments")
    public List<String> getTriggerWithSegments() {
        return this.triggerWithSegments;
    }

    public void setTriggerWithSegments(List<String> triggerWithSegments) {
        this.triggerWithSegments = triggerWithSegments;
    }

    public ActionMap triggerWithEventConditions(List<EventCondition> triggerWithEventConditions) {
        this.triggerWithEventConditions = triggerWithEventConditions;
        return this;
    }

    @ApiModelProperty(example="null", value="List of event conditions that must be satisfied to trigger the action map.")
    @JsonProperty(value="triggerWithEventConditions")
    public List<EventCondition> getTriggerWithEventConditions() {
        return this.triggerWithEventConditions;
    }

    public void setTriggerWithEventConditions(List<EventCondition> triggerWithEventConditions) {
        this.triggerWithEventConditions = triggerWithEventConditions;
    }

    public ActionMap triggerWithOutcomeProbabilityConditions(List<OutcomeProbabilityCondition> triggerWithOutcomeProbabilityConditions) {
        this.triggerWithOutcomeProbabilityConditions = triggerWithOutcomeProbabilityConditions;
        return this;
    }

    @ApiModelProperty(example="null", value="Probability conditions for outcomes that must be satisfied to trigger the action map.")
    @JsonProperty(value="triggerWithOutcomeProbabilityConditions")
    public List<OutcomeProbabilityCondition> getTriggerWithOutcomeProbabilityConditions() {
        return this.triggerWithOutcomeProbabilityConditions;
    }

    public void setTriggerWithOutcomeProbabilityConditions(List<OutcomeProbabilityCondition> triggerWithOutcomeProbabilityConditions) {
        this.triggerWithOutcomeProbabilityConditions = triggerWithOutcomeProbabilityConditions;
    }

    public ActionMap pageUrlConditions(List<UrlCondition> pageUrlConditions) {
        this.pageUrlConditions = pageUrlConditions;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="URL conditions that a page must match for web actions to be displayable.")
    @JsonProperty(value="pageUrlConditions")
    public List<UrlCondition> getPageUrlConditions() {
        return this.pageUrlConditions;
    }

    public void setPageUrlConditions(List<UrlCondition> pageUrlConditions) {
        this.pageUrlConditions = pageUrlConditions;
    }

    public ActionMap activation(Activation activation) {
        this.activation = activation;
        return this;
    }

    @ApiModelProperty(example="null", value="Type of activation.")
    @JsonProperty(value="activation")
    public Activation getActivation() {
        return this.activation;
    }

    public void setActivation(Activation activation) {
        this.activation = activation;
    }

    public ActionMap weight(Integer weight) {
        this.weight = weight;
        return this;
    }

    @ApiModelProperty(example="null", value="Weight of the action map with higher number denoting higher weight.")
    @JsonProperty(value="weight")
    public Integer getWeight() {
        return this.weight;
    }

    public void setWeight(Integer weight) {
        this.weight = weight;
    }

    public ActionMap action(ActionMapAction action) {
        this.action = action;
        return this;
    }

    @ApiModelProperty(example="null", value="The action that will be executed if this action map is triggered.")
    @JsonProperty(value="action")
    public ActionMapAction getAction() {
        return this.action;
    }

    public void setAction(ActionMapAction action) {
        this.action = action;
    }

    public ActionMap actionMapScheduleGroups(ActionMapScheduleGroups actionMapScheduleGroups) {
        this.actionMapScheduleGroups = actionMapScheduleGroups;
        return this;
    }

    @ApiModelProperty(example="null", value="The action map's associated schedule groups.")
    @JsonProperty(value="actionMapScheduleGroups")
    public ActionMapScheduleGroups getActionMapScheduleGroups() {
        return this.actionMapScheduleGroups;
    }

    public void setActionMapScheduleGroups(ActionMapScheduleGroups actionMapScheduleGroups) {
        this.actionMapScheduleGroups = actionMapScheduleGroups;
    }

    public ActionMap ignoreFrequencyCap(Boolean ignoreFrequencyCap) {
        this.ignoreFrequencyCap = ignoreFrequencyCap;
        return this;
    }

    @ApiModelProperty(example="null", value="Override organization-level frequency cap and always offer web engagements from this action map.")
    @JsonProperty(value="ignoreFrequencyCap")
    public Boolean getIgnoreFrequencyCap() {
        return this.ignoreFrequencyCap;
    }

    public void setIgnoreFrequencyCap(Boolean ignoreFrequencyCap) {
        this.ignoreFrequencyCap = ignoreFrequencyCap;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public ActionMap createdDate(Date createdDate) {
        this.createdDate = createdDate;
        return this;
    }

    @ApiModelProperty(example="null", value="Timestamp indicating when the action map was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="createdDate")
    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public ActionMap modifiedDate(Date modifiedDate) {
        this.modifiedDate = modifiedDate;
        return this;
    }

    @ApiModelProperty(example="null", value="Timestamp indicating when the action map was last updated. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="modifiedDate")
    public Date getModifiedDate() {
        return this.modifiedDate;
    }

    public void setModifiedDate(Date modifiedDate) {
        this.modifiedDate = modifiedDate;
    }

    public ActionMap startDate(Date startDate) {
        this.startDate = startDate;
        return this;
    }

    @ApiModelProperty(example="null", value="Timestamp at which the action map is scheduled to start firing. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="startDate")
    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public ActionMap endDate(Date endDate) {
        this.endDate = endDate;
        return this;
    }

    @ApiModelProperty(example="null", value="Timestamp at which the action map is scheduled to stop firing. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="endDate")
    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActionMap actionMap = (ActionMap)o;
        return Objects.equals(this.id, actionMap.id) && Objects.equals(this.version, actionMap.version) && Objects.equals(this.isActive, actionMap.isActive) && Objects.equals(this.displayName, actionMap.displayName) && Objects.equals(this.triggerWithSegments, actionMap.triggerWithSegments) && Objects.equals(this.triggerWithEventConditions, actionMap.triggerWithEventConditions) && Objects.equals(this.triggerWithOutcomeProbabilityConditions, actionMap.triggerWithOutcomeProbabilityConditions) && Objects.equals(this.pageUrlConditions, actionMap.pageUrlConditions) && Objects.equals(this.activation, actionMap.activation) && Objects.equals(this.weight, actionMap.weight) && Objects.equals(this.action, actionMap.action) && Objects.equals(this.actionMapScheduleGroups, actionMap.actionMapScheduleGroups) && Objects.equals(this.ignoreFrequencyCap, actionMap.ignoreFrequencyCap) && Objects.equals(this.selfUri, actionMap.selfUri) && Objects.equals(this.createdDate, actionMap.createdDate) && Objects.equals(this.modifiedDate, actionMap.modifiedDate) && Objects.equals(this.startDate, actionMap.startDate) && Objects.equals(this.endDate, actionMap.endDate);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.version, this.isActive, this.displayName, this.triggerWithSegments, this.triggerWithEventConditions, this.triggerWithOutcomeProbabilityConditions, this.pageUrlConditions, this.activation, this.weight, this.action, this.actionMapScheduleGroups, this.ignoreFrequencyCap, this.selfUri, this.createdDate, this.modifiedDate, this.startDate, this.endDate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ActionMap {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    isActive: ").append(this.toIndentedString(this.isActive)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    triggerWithSegments: ").append(this.toIndentedString(this.triggerWithSegments)).append("\n");
        sb.append("    triggerWithEventConditions: ").append(this.toIndentedString(this.triggerWithEventConditions)).append("\n");
        sb.append("    triggerWithOutcomeProbabilityConditions: ").append(this.toIndentedString(this.triggerWithOutcomeProbabilityConditions)).append("\n");
        sb.append("    pageUrlConditions: ").append(this.toIndentedString(this.pageUrlConditions)).append("\n");
        sb.append("    activation: ").append(this.toIndentedString(this.activation)).append("\n");
        sb.append("    weight: ").append(this.toIndentedString(this.weight)).append("\n");
        sb.append("    action: ").append(this.toIndentedString(this.action)).append("\n");
        sb.append("    actionMapScheduleGroups: ").append(this.toIndentedString(this.actionMapScheduleGroups)).append("\n");
        sb.append("    ignoreFrequencyCap: ").append(this.toIndentedString(this.ignoreFrequencyCap)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("    createdDate: ").append(this.toIndentedString(this.createdDate)).append("\n");
        sb.append("    modifiedDate: ").append(this.toIndentedString(this.modifiedDate)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

