/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.OutcomeConfig;
import com.mypurecloud.sdk.v2.model.WrapUpCodeConfig;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class KeyPerformanceIndicator
implements Serializable {
    private String id = null;
    private String name = null;
    private OptimizationTypeEnum optimizationType = null;
    private Date dateCreated = null;
    private Date dateModified = null;
    private String description = null;
    private KpiTypeEnum kpiType = null;
    private SourceEnum source = null;
    private WrapUpCodeConfig wrapUpCodeConfig = null;
    private OutcomeConfig outcomeConfig = null;
    private StatusEnum status = null;
    private KpiGroupEnum kpiGroup = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @ApiModelProperty(example="null", value="The name of the Key Performance Indicator.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @ApiModelProperty(example="null", value="The optimization type of the Key Performance Indicator.")
    @JsonProperty(value="optimizationType")
    public OptimizationTypeEnum getOptimizationType() {
        return this.optimizationType;
    }

    @ApiModelProperty(example="null", value="DateTime indicating when the Key Performance Indicator was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    @ApiModelProperty(example="null", value="DateTime indicating when the Key Performance Indicator was modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    @ApiModelProperty(example="null", value="The description of the Key Performance Indicator.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @ApiModelProperty(example="null", value="The type of Key Performance Indicator.")
    @JsonProperty(value="kpiType")
    public KpiTypeEnum getKpiType() {
        return this.kpiType;
    }

    @ApiModelProperty(example="null", value="Source of values for Key Performance Indicator.")
    @JsonProperty(value="source")
    public SourceEnum getSource() {
        return this.source;
    }

    @ApiModelProperty(example="null", value="Defines what wrap up codes are mapped to Key Performance Indicator.")
    @JsonProperty(value="wrapUpCodeConfig")
    public WrapUpCodeConfig getWrapUpCodeConfig() {
        return this.wrapUpCodeConfig;
    }

    @ApiModelProperty(example="null", value="Defines what outcome ids are mapped to Key Performance Indicator.")
    @JsonProperty(value="outcomeConfig")
    public OutcomeConfig getOutcomeConfig() {
        return this.outcomeConfig;
    }

    @ApiModelProperty(example="null", value="The status of the Key Performance Indicator.")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    @ApiModelProperty(example="null", value="The group the Key Performance Indicator belongs to.")
    @JsonProperty(value="kpiGroup")
    public KpiGroupEnum getKpiGroup() {
        return this.kpiGroup;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyPerformanceIndicator keyPerformanceIndicator = (KeyPerformanceIndicator)o;
        return Objects.equals(this.id, keyPerformanceIndicator.id) && Objects.equals(this.name, keyPerformanceIndicator.name) && Objects.equals((Object)this.optimizationType, (Object)keyPerformanceIndicator.optimizationType) && Objects.equals(this.dateCreated, keyPerformanceIndicator.dateCreated) && Objects.equals(this.dateModified, keyPerformanceIndicator.dateModified) && Objects.equals(this.description, keyPerformanceIndicator.description) && Objects.equals((Object)this.kpiType, (Object)keyPerformanceIndicator.kpiType) && Objects.equals((Object)this.source, (Object)keyPerformanceIndicator.source) && Objects.equals(this.wrapUpCodeConfig, keyPerformanceIndicator.wrapUpCodeConfig) && Objects.equals(this.outcomeConfig, keyPerformanceIndicator.outcomeConfig) && Objects.equals((Object)this.status, (Object)keyPerformanceIndicator.status) && Objects.equals((Object)this.kpiGroup, (Object)keyPerformanceIndicator.kpiGroup) && Objects.equals(this.selfUri, keyPerformanceIndicator.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.optimizationType, this.dateCreated, this.dateModified, this.description, this.kpiType, this.source, this.wrapUpCodeConfig, this.outcomeConfig, this.status, this.kpiGroup, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class KeyPerformanceIndicator {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    optimizationType: ").append(this.toIndentedString((Object)this.optimizationType)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    kpiType: ").append(this.toIndentedString((Object)this.kpiType)).append("\n");
        sb.append("    source: ").append(this.toIndentedString((Object)this.source)).append("\n");
        sb.append("    wrapUpCodeConfig: ").append(this.toIndentedString(this.wrapUpCodeConfig)).append("\n");
        sb.append("    outcomeConfig: ").append(this.toIndentedString(this.outcomeConfig)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    kpiGroup: ").append(this.toIndentedString((Object)this.kpiGroup)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=KpiGroupEnumDeserializer.class)
    public static enum KpiGroupEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        STANDARD("Standard"),
        CUSTOM("Custom");

        private String value;

        private KpiGroupEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static KpiGroupEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (KpiGroupEnum value : KpiGroupEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return KpiGroupEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class KpiGroupEnumDeserializer
    extends StdDeserializer<KpiGroupEnum> {
        public KpiGroupEnumDeserializer() {
            super(KpiGroupEnumDeserializer.class);
        }

        public KpiGroupEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return KpiGroupEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=StatusEnumDeserializer.class)
    public static enum StatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ENABLED("Enabled"),
        DISABLED("Disabled");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StatusEnum value : StatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StatusEnumDeserializer
    extends StdDeserializer<StatusEnum> {
        public StatusEnumDeserializer() {
            super(StatusEnumDeserializer.class);
        }

        public StatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=SourceEnumDeserializer.class)
    public static enum SourceEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        WRAPUPCODE("WrapUpCode"),
        OUTCOME("Outcome"),
        NONE("None");

        private String value;

        private SourceEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static SourceEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (SourceEnum value : SourceEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return SourceEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class SourceEnumDeserializer
    extends StdDeserializer<SourceEnum> {
        public SourceEnumDeserializer() {
            super(SourceEnumDeserializer.class);
        }

        public SourceEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return SourceEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=KpiTypeEnumDeserializer.class)
    public static enum KpiTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        SALESCONVERSION("SalesConversion"),
        CHURN("Churn"),
        RETENTION("Retention"),
        SALESVALUE("SalesValue"),
        HANDLETIME("HandleTime"),
        NUMBEROFTRANSFERS("NumberOfTransfers");

        private String value;

        private KpiTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static KpiTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (KpiTypeEnum value : KpiTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return KpiTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class KpiTypeEnumDeserializer
    extends StdDeserializer<KpiTypeEnum> {
        public KpiTypeEnumDeserializer() {
            super(KpiTypeEnumDeserializer.class);
        }

        public KpiTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return KpiTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=OptimizationTypeEnumDeserializer.class)
    public static enum OptimizationTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        MAXIMIZATION("Maximization"),
        MINIMIZATION("Minimization");

        private String value;

        private OptimizationTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static OptimizationTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (OptimizationTypeEnum value : OptimizationTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return OptimizationTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class OptimizationTypeEnumDeserializer
    extends StdDeserializer<OptimizationTypeEnum> {
        public OptimizationTypeEnumDeserializer() {
            super(OptimizationTypeEnumDeserializer.class);
        }

        public OptimizationTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return OptimizationTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

