/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class GetTeamRequest {
    private String teamId;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getTeamId() {
        return this.teamId;
    }

    public void setTeamId(String teamId) {
        this.teamId = teamId;
    }

    public GetTeamRequest withTeamId(String teamId) {
        this.setTeamId(teamId);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetTeamRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.teamId == null) {
            throw new IllegalStateException("Missing the required parameter 'teamId' when building request for GetTeamRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/teams/{teamId}").withPathParameter("teamId", this.teamId).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String teamId) {
        return new Builder().withRequiredParams(teamId);
    }

    public static class Builder {
        private final GetTeamRequest request = new GetTeamRequest();

        private Builder() {
        }

        public Builder withTeamId(String teamId) {
            this.request.setTeamId(teamId);
            return this;
        }

        public Builder withRequiredParams(String teamId) {
            this.request.setTeamId(teamId);
            return this;
        }

        public GetTeamRequest build() {
            if (this.request.teamId == null) {
                throw new IllegalStateException("Missing the required parameter 'teamId' when building request for GetTeamRequest.");
            }
            return this.request;
        }
    }
}

