/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.ConversationAssociation;
import java.util.HashMap;
import java.util.Map;

public class PutExternalcontactsConversationRequest {
    private String conversationId;
    private ConversationAssociation body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public PutExternalcontactsConversationRequest withConversationId(String conversationId) {
        this.setConversationId(conversationId);
        return this;
    }

    public ConversationAssociation getBody() {
        return this.body;
    }

    public void setBody(ConversationAssociation body) {
        this.body = body;
    }

    public PutExternalcontactsConversationRequest withBody(ConversationAssociation body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PutExternalcontactsConversationRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<ConversationAssociation> withHttpInfo() {
        if (this.conversationId == null) {
            throw new IllegalStateException("Missing the required parameter 'conversationId' when building request for PutExternalcontactsConversationRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PutExternalcontactsConversationRequest.");
        }
        return ApiRequestBuilder.create("PUT", "/api/v2/externalcontacts/conversations/{conversationId}").withPathParameter("conversationId", this.conversationId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String conversationId, ConversationAssociation body) {
        return new Builder().withRequiredParams(conversationId, body);
    }

    public static class Builder {
        private final PutExternalcontactsConversationRequest request = new PutExternalcontactsConversationRequest();

        private Builder() {
        }

        public Builder withConversationId(String conversationId) {
            this.request.setConversationId(conversationId);
            return this;
        }

        public Builder withBody(ConversationAssociation body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String conversationId, ConversationAssociation body) {
            this.request.setConversationId(conversationId);
            this.request.setBody(body);
            return this;
        }

        public PutExternalcontactsConversationRequest build() {
            if (this.request.conversationId == null) {
                throw new IllegalStateException("Missing the required parameter 'conversationId' when building request for PutExternalcontactsConversationRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PutExternalcontactsConversationRequest.");
            }
            return this.request;
        }
    }
}

