/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.Team;
import java.util.HashMap;
import java.util.Map;

public class PatchTeamRequest {
    private String teamId;
    private Team body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getTeamId() {
        return this.teamId;
    }

    public void setTeamId(String teamId) {
        this.teamId = teamId;
    }

    public PatchTeamRequest withTeamId(String teamId) {
        this.setTeamId(teamId);
        return this;
    }

    public Team getBody() {
        return this.body;
    }

    public void setBody(Team body) {
        this.body = body;
    }

    public PatchTeamRequest withBody(Team body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PatchTeamRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Team> withHttpInfo() {
        if (this.teamId == null) {
            throw new IllegalStateException("Missing the required parameter 'teamId' when building request for PatchTeamRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchTeamRequest.");
        }
        return ApiRequestBuilder.create("PATCH", "/api/v2/teams/{teamId}").withPathParameter("teamId", this.teamId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String teamId, Team body) {
        return new Builder().withRequiredParams(teamId, body);
    }

    public static class Builder {
        private final PatchTeamRequest request = new PatchTeamRequest();

        private Builder() {
        }

        public Builder withTeamId(String teamId) {
            this.request.setTeamId(teamId);
            return this;
        }

        public Builder withBody(Team body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String teamId, Team body) {
            this.request.setTeamId(teamId);
            this.request.setBody(body);
            return this;
        }

        public PatchTeamRequest build() {
            if (this.request.teamId == null) {
                throw new IllegalStateException("Missing the required parameter 'teamId' when building request for PatchTeamRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchTeamRequest.");
            }
            return this.request;
        }
    }
}

