/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.WebMessagingRecipient;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

@ApiModel(description="Channel-specific information that describes the message and the message channel/provider.")
public class WebMessagingChannel
implements Serializable {
    private WebMessagingRecipient from = null;
    private WebMessagingRecipient to = null;
    private Date time = null;
    private String messageId = null;

    @ApiModelProperty(example="null", value="Information about the recipient the message is received from.")
    @JsonProperty(value="from")
    public WebMessagingRecipient getFrom() {
        return this.from;
    }

    @ApiModelProperty(example="null", value="Information about the recipient the message is sent to.")
    @JsonProperty(value="to")
    public WebMessagingRecipient getTo() {
        return this.to;
    }

    @ApiModelProperty(example="null", value="When the message was processed by Genesys Cloud. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="time")
    public Date getTime() {
        return this.time;
    }

    @ApiModelProperty(example="null", value="Unique provider ID of the message.")
    @JsonProperty(value="messageId")
    public String getMessageId() {
        return this.messageId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebMessagingChannel webMessagingChannel = (WebMessagingChannel)o;
        return Objects.equals(this.from, webMessagingChannel.from) && Objects.equals(this.to, webMessagingChannel.to) && Objects.equals(this.time, webMessagingChannel.time) && Objects.equals(this.messageId, webMessagingChannel.messageId);
    }

    public int hashCode() {
        return Objects.hash(this.from, this.to, this.time, this.messageId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WebMessagingChannel {\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    to: ").append(this.toIndentedString(this.to)).append("\n");
        sb.append("    time: ").append(this.toIndentedString(this.time)).append("\n");
        sb.append("    messageId: ").append(this.toIndentedString(this.messageId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

