/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="Defines an authentication scheme in the SCIM service provider's configuration.")
public class ScimServiceProviderConfigAuthenticationScheme
implements Serializable {
    private String name = null;
    private String description = null;
    private String specUri = null;
    private String documentationUri = null;
    private TypeEnum type = null;
    private Boolean primary = null;

    @ApiModelProperty(example="null", required=true, value="The name of the authentication scheme, for example, HTTP Basic.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @ApiModelProperty(example="null", required=true, value="The description of the authentication scheme.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @ApiModelProperty(example="null", value="The HTTP-addressable URL that points to the authentication scheme's specification.")
    @JsonProperty(value="specUri")
    public String getSpecUri() {
        return this.specUri;
    }

    @ApiModelProperty(example="null", value="The HTTP-addressable URL that points to the authentication scheme's usage documentation.")
    @JsonProperty(value="documentationUri")
    public String getDocumentationUri() {
        return this.documentationUri;
    }

    @ApiModelProperty(example="null", required=true, value="The type of authentication scheme.")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    @ApiModelProperty(example="null", value="Indicates whether this authentication scheme is the primary method of authentication.")
    @JsonProperty(value="primary")
    public Boolean getPrimary() {
        return this.primary;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScimServiceProviderConfigAuthenticationScheme scimServiceProviderConfigAuthenticationScheme = (ScimServiceProviderConfigAuthenticationScheme)o;
        return Objects.equals(this.name, scimServiceProviderConfigAuthenticationScheme.name) && Objects.equals(this.description, scimServiceProviderConfigAuthenticationScheme.description) && Objects.equals(this.specUri, scimServiceProviderConfigAuthenticationScheme.specUri) && Objects.equals(this.documentationUri, scimServiceProviderConfigAuthenticationScheme.documentationUri) && Objects.equals((Object)this.type, (Object)scimServiceProviderConfigAuthenticationScheme.type) && Objects.equals(this.primary, scimServiceProviderConfigAuthenticationScheme.primary);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.description, this.specUri, this.documentationUri, this.type, this.primary});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScimServiceProviderConfigAuthenticationScheme {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    specUri: ").append(this.toIndentedString(this.specUri)).append("\n");
        sb.append("    documentationUri: ").append(this.toIndentedString(this.documentationUri)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    primary: ").append(this.toIndentedString(this.primary)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=TypeEnumDeserializer.class)
    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        OAUTH("oauth"),
        OAUTH2("oauth2"),
        OAUTHBEARERTOKEN("oauthbearertoken"),
        HTTPBASIC("httpbasic"),
        HTTPDIGEST("httpdigest");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class TypeEnumDeserializer
    extends StdDeserializer<TypeEnum> {
        public TypeEnumDeserializer() {
            super(TypeEnumDeserializer.class);
        }

        public TypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

