/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.ConversationMessageMetadataContent;
import com.mypurecloud.sdk.v2.model.ConversationMessageMetadataEvent;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Metadata information about a message.")
public class ConversationMessageMetadata
implements Serializable {
    private TypeEnum type = null;
    private List<ConversationMessageMetadataEvent> events = new ArrayList<ConversationMessageMetadataEvent>();
    private List<ConversationMessageMetadataContent> content = new ArrayList<ConversationMessageMetadataContent>();

    public ConversationMessageMetadata type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", value="Message type.")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public ConversationMessageMetadata events(List<ConversationMessageMetadataEvent> events) {
        this.events = events;
        return this;
    }

    @ApiModelProperty(example="null", value="List of events metadata")
    @JsonProperty(value="events")
    public List<ConversationMessageMetadataEvent> getEvents() {
        return this.events;
    }

    public void setEvents(List<ConversationMessageMetadataEvent> events) {
        this.events = events;
    }

    public ConversationMessageMetadata content(List<ConversationMessageMetadataContent> content) {
        this.content = content;
        return this;
    }

    @ApiModelProperty(example="null", value="List of message content")
    @JsonProperty(value="content")
    public List<ConversationMessageMetadataContent> getContent() {
        return this.content;
    }

    public void setContent(List<ConversationMessageMetadataContent> content) {
        this.content = content;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConversationMessageMetadata conversationMessageMetadata = (ConversationMessageMetadata)o;
        return Objects.equals((Object)this.type, (Object)conversationMessageMetadata.type) && Objects.equals(this.events, conversationMessageMetadata.events) && Objects.equals(this.content, conversationMessageMetadata.content);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.events, this.content});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConversationMessageMetadata {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    events: ").append(this.toIndentedString(this.events)).append("\n");
        sb.append("    content: ").append(this.toIndentedString(this.content)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=TypeEnumDeserializer.class)
    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        TEXT("Text"),
        STRUCTURED("Structured"),
        RECEIPT("Receipt"),
        EVENT("Event"),
        MESSAGE("Message"),
        UNKNOWN("Unknown");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class TypeEnumDeserializer
    extends StdDeserializer<TypeEnum> {
        public TypeEnumDeserializer() {
            super(TypeEnumDeserializer.class);
        }

        public TypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

