/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class GetIntegrationsTypeConfigschemaRequest {
    private String typeId;
    private String configType;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getTypeId() {
        return this.typeId;
    }

    public void setTypeId(String typeId) {
        this.typeId = typeId;
    }

    public GetIntegrationsTypeConfigschemaRequest withTypeId(String typeId) {
        this.setTypeId(typeId);
        return this;
    }

    public String getConfigType() {
        return this.configType;
    }

    public void setConfigType(String configType) {
        this.configType = configType;
    }

    public GetIntegrationsTypeConfigschemaRequest withConfigType(String configType) {
        this.setConfigType(configType);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetIntegrationsTypeConfigschemaRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.typeId == null) {
            throw new IllegalStateException("Missing the required parameter 'typeId' when building request for GetIntegrationsTypeConfigschemaRequest.");
        }
        if (this.configType == null) {
            throw new IllegalStateException("Missing the required parameter 'configType' when building request for GetIntegrationsTypeConfigschemaRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/integrations/types/{typeId}/configschemas/{configType}").withPathParameter("typeId", this.typeId).withPathParameter("configType", this.configType).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String typeId, String configType) {
        return new Builder().withRequiredParams(typeId, configType);
    }

    public static class Builder {
        private final GetIntegrationsTypeConfigschemaRequest request = new GetIntegrationsTypeConfigschemaRequest();

        private Builder() {
        }

        public Builder withTypeId(String typeId) {
            this.request.setTypeId(typeId);
            return this;
        }

        public Builder withConfigType(String configType) {
            this.request.setConfigType(configType);
            return this;
        }

        public Builder withConfigType(configTypeValues configType) {
            this.request.setConfigType(configType.toString());
            return this;
        }

        public Builder withRequiredParams(String typeId, String configType) {
            this.request.setTypeId(typeId);
            this.request.setConfigType(configType);
            return this;
        }

        public GetIntegrationsTypeConfigschemaRequest build() {
            if (this.request.typeId == null) {
                throw new IllegalStateException("Missing the required parameter 'typeId' when building request for GetIntegrationsTypeConfigschemaRequest.");
            }
            if (this.request.configType == null) {
                throw new IllegalStateException("Missing the required parameter 'configType' when building request for GetIntegrationsTypeConfigschemaRequest.");
            }
            return this.request;
        }
    }

    public static enum configTypeValues {
        PROPERTIES("properties"),
        ADVANCED("advanced");

        private String value;

        private configTypeValues(String value) {
            this.value = value;
        }

        @JsonCreator
        public static configTypeValues fromString(String key) {
            if (key == null) {
                return null;
            }
            for (configTypeValues value : configTypeValues.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return configTypeValues.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

