/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class WrapUpCodeMapping
implements Serializable {
    private String id = null;
    private String name = null;
    private Date dateCreated = null;
    private Date dateModified = null;
    private Integer version = null;
    private List<DefaultSetEnum> defaultSet = null;
    private Map<String, List<String>> mapping = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public WrapUpCodeMapping name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(example="null", value="Creation time of the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    @ApiModelProperty(example="null", value="Last modified time of the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    public WrapUpCodeMapping version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(example="null", value="Required for updates, must match the version number of the most recent update")
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public WrapUpCodeMapping defaultSet(List<DefaultSetEnum> defaultSet) {
        this.defaultSet = defaultSet;
        return this;
    }

    @ApiModelProperty(example="null", value="The default set of wrap-up flags. These will be used if there is no entry for a given wrap-up code in the mapping.")
    @JsonProperty(value="defaultSet")
    public List<DefaultSetEnum> getDefaultSet() {
        return this.defaultSet;
    }

    public void setDefaultSet(List<DefaultSetEnum> defaultSet) {
        this.defaultSet = defaultSet;
    }

    public WrapUpCodeMapping mapping(Map<String, List<String>> mapping) {
        this.mapping = mapping;
        return this;
    }

    @ApiModelProperty(example="null", value="A map from wrap-up code identifiers to a set of wrap-up flags.")
    @JsonProperty(value="mapping")
    public Map<String, List<String>> getMapping() {
        return this.mapping;
    }

    public void setMapping(Map<String, List<String>> mapping) {
        this.mapping = mapping;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WrapUpCodeMapping wrapUpCodeMapping = (WrapUpCodeMapping)o;
        return Objects.equals(this.id, wrapUpCodeMapping.id) && Objects.equals(this.name, wrapUpCodeMapping.name) && Objects.equals(this.dateCreated, wrapUpCodeMapping.dateCreated) && Objects.equals(this.dateModified, wrapUpCodeMapping.dateModified) && Objects.equals(this.version, wrapUpCodeMapping.version) && Objects.equals(this.defaultSet, wrapUpCodeMapping.defaultSet) && Objects.equals(this.mapping, wrapUpCodeMapping.mapping) && Objects.equals(this.selfUri, wrapUpCodeMapping.selfUri);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.dateCreated, this.dateModified, this.version, this.defaultSet, this.mapping, this.selfUri);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WrapUpCodeMapping {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    defaultSet: ").append(this.toIndentedString(this.defaultSet)).append("\n");
        sb.append("    mapping: ").append(this.toIndentedString(this.mapping)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=DefaultSetEnumDeserializer.class)
    public static enum DefaultSetEnum {
        CONTACT_UNCALLABLE("CONTACT_UNCALLABLE"),
        NUMBER_UNCALLABLE("NUMBER_UNCALLABLE"),
        RIGHT_PARTY_CONTACT("RIGHT_PARTY_CONTACT");

        private String value;

        private DefaultSetEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DefaultSetEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (DefaultSetEnum value : DefaultSetEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return DefaultSetEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class DefaultSetEnumDeserializer
    extends StdDeserializer<DefaultSetEnum> {
        public DefaultSetEnumDeserializer() {
            super(DefaultSetEnumDeserializer.class);
        }

        public DefaultSetEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return DefaultSetEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

