/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.AddressableEntityRef;
import com.mypurecloud.sdk.v2.model.DomainEntityRef;
import com.mypurecloud.sdk.v2.model.WorkdayValuesTrendItem;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;

public class WorkdayValuesMetricItem
implements Serializable {
    private AddressableEntityRef metric = null;
    private DomainEntityRef metricDefinition = null;
    private Double average = null;
    private UnitTypeEnum unitType = null;
    private List<WorkdayValuesTrendItem> trend = null;

    @ApiModelProperty(example="null", value="Gamification metric for the average and the trend")
    @JsonProperty(value="metric")
    public AddressableEntityRef getMetric() {
        return this.metric;
    }

    @ApiModelProperty(example="null", value="Gamification metric definition for the average and the trend")
    @JsonProperty(value="metricDefinition")
    public DomainEntityRef getMetricDefinition() {
        return this.metricDefinition;
    }

    @ApiModelProperty(example="null", value="The average value of the metric")
    @JsonProperty(value="average")
    public Double getAverage() {
        return this.average;
    }

    @ApiModelProperty(example="null", value="The unit type of the metric value")
    @JsonProperty(value="unitType")
    public UnitTypeEnum getUnitType() {
        return this.unitType;
    }

    @ApiModelProperty(example="null", value="The metric value trend")
    @JsonProperty(value="trend")
    public List<WorkdayValuesTrendItem> getTrend() {
        return this.trend;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkdayValuesMetricItem workdayValuesMetricItem = (WorkdayValuesMetricItem)o;
        return Objects.equals(this.metric, workdayValuesMetricItem.metric) && Objects.equals(this.metricDefinition, workdayValuesMetricItem.metricDefinition) && Objects.equals(this.average, workdayValuesMetricItem.average) && Objects.equals((Object)this.unitType, (Object)workdayValuesMetricItem.unitType) && Objects.equals(this.trend, workdayValuesMetricItem.trend);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.metric, this.metricDefinition, this.average, this.unitType, this.trend});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WorkdayValuesMetricItem {\n");
        sb.append("    metric: ").append(this.toIndentedString(this.metric)).append("\n");
        sb.append("    metricDefinition: ").append(this.toIndentedString(this.metricDefinition)).append("\n");
        sb.append("    average: ").append(this.toIndentedString(this.average)).append("\n");
        sb.append("    unitType: ").append(this.toIndentedString((Object)this.unitType)).append("\n");
        sb.append("    trend: ").append(this.toIndentedString(this.trend)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=UnitTypeEnumDeserializer.class)
    public static enum UnitTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        NONE("None"),
        PERCENT("Percent"),
        CURRENCY("Currency"),
        SECONDS("Seconds"),
        NUMBER("Number"),
        ATTENDANCESTATUS("AttendanceStatus"),
        UNIT("Unit");

        private String value;

        private UnitTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static UnitTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (UnitTypeEnum value : UnitTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return UnitTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class UnitTypeEnumDeserializer
    extends StdDeserializer<UnitTypeEnum> {
        public UnitTypeEnumDeserializer() {
            super(UnitTypeEnumDeserializer.class);
        }

        public UnitTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return UnitTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

