/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.UserReference;
import com.mypurecloud.sdk.v2.model.WorkdayPointsTrendItem;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;

public class WorkdayPointsTrend
implements Serializable {
    private LocalDate dateStartWorkday = null;
    private LocalDate dateEndWorkday = null;
    private UserReference user = null;
    private DayOfWeekEnum dayOfWeek = null;
    private Double averagePoints = null;
    private List<WorkdayPointsTrendItem> trend = null;

    @ApiModelProperty(example="null", value="The start workday for the query range for the gamification points trend. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd")
    @JsonProperty(value="dateStartWorkday")
    public LocalDate getDateStartWorkday() {
        return this.dateStartWorkday;
    }

    @ApiModelProperty(example="null", value="The end workday for the query range for the gamification points trend. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd")
    @JsonProperty(value="dateEndWorkday")
    public LocalDate getDateEndWorkday() {
        return this.dateEndWorkday;
    }

    @ApiModelProperty(example="null", value="The targeted user for the query")
    @JsonProperty(value="user")
    public UserReference getUser() {
        return this.user;
    }

    @ApiModelProperty(example="null", value="Aggregated for same day comparison")
    @JsonProperty(value="dayOfWeek")
    public DayOfWeekEnum getDayOfWeek() {
        return this.dayOfWeek;
    }

    @ApiModelProperty(example="null", value="The total average points")
    @JsonProperty(value="averagePoints")
    public Double getAveragePoints() {
        return this.averagePoints;
    }

    @ApiModelProperty(example="null", value="Daily points trends")
    @JsonProperty(value="trend")
    public List<WorkdayPointsTrendItem> getTrend() {
        return this.trend;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkdayPointsTrend workdayPointsTrend = (WorkdayPointsTrend)o;
        return Objects.equals(this.dateStartWorkday, workdayPointsTrend.dateStartWorkday) && Objects.equals(this.dateEndWorkday, workdayPointsTrend.dateEndWorkday) && Objects.equals(this.user, workdayPointsTrend.user) && Objects.equals((Object)this.dayOfWeek, (Object)workdayPointsTrend.dayOfWeek) && Objects.equals(this.averagePoints, workdayPointsTrend.averagePoints) && Objects.equals(this.trend, workdayPointsTrend.trend);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.dateStartWorkday, this.dateEndWorkday, this.user, this.dayOfWeek, this.averagePoints, this.trend});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WorkdayPointsTrend {\n");
        sb.append("    dateStartWorkday: ").append(this.toIndentedString(this.dateStartWorkday)).append("\n");
        sb.append("    dateEndWorkday: ").append(this.toIndentedString(this.dateEndWorkday)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    dayOfWeek: ").append(this.toIndentedString((Object)this.dayOfWeek)).append("\n");
        sb.append("    averagePoints: ").append(this.toIndentedString(this.averagePoints)).append("\n");
        sb.append("    trend: ").append(this.toIndentedString(this.trend)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=DayOfWeekEnumDeserializer.class)
    public static enum DayOfWeekEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        SUNDAY("Sunday"),
        MONDAY("Monday"),
        TUESDAY("Tuesday"),
        WEDNESDAY("Wednesday"),
        THURSDAY("Thursday"),
        FRIDAY("Friday"),
        SATURDAY("Saturday");

        private String value;

        private DayOfWeekEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DayOfWeekEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (DayOfWeekEnum value : DayOfWeekEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return DayOfWeekEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class DayOfWeekEnumDeserializer
    extends StdDeserializer<DayOfWeekEnum> {
        public DayOfWeekEnumDeserializer() {
            super(DayOfWeekEnumDeserializer.class);
        }

        public DayOfWeekEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return DayOfWeekEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

