/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.WfmScheduleReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Update coaching appointment request")
public class UpdateCoachingAppointmentRequest
implements Serializable {
    private String name = null;
    private String description = null;
    private Date dateStart = null;
    private Integer lengthInMinutes = null;
    private List<String> conversationIds = null;
    private List<String> documentIds = null;
    private StatusEnum status = null;
    private WfmScheduleReference wfmSchedule = null;
    private List<String> externalLinks = null;

    public UpdateCoachingAppointmentRequest name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="The name of coaching appointment.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public UpdateCoachingAppointmentRequest description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="The description of coaching appointment.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public UpdateCoachingAppointmentRequest dateStart(Date dateStart) {
        this.dateStart = dateStart;
        return this;
    }

    @ApiModelProperty(example="null", value="The date/time the coaching appointment starts. Times will be rounded down to the minute. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateStart")
    public Date getDateStart() {
        return this.dateStart;
    }

    public void setDateStart(Date dateStart) {
        this.dateStart = dateStart;
    }

    public UpdateCoachingAppointmentRequest lengthInMinutes(Integer lengthInMinutes) {
        this.lengthInMinutes = lengthInMinutes;
        return this;
    }

    @ApiModelProperty(example="null", value="The duration of coaching appointment in minutes.")
    @JsonProperty(value="lengthInMinutes")
    public Integer getLengthInMinutes() {
        return this.lengthInMinutes;
    }

    public void setLengthInMinutes(Integer lengthInMinutes) {
        this.lengthInMinutes = lengthInMinutes;
    }

    public UpdateCoachingAppointmentRequest conversationIds(List<String> conversationIds) {
        this.conversationIds = conversationIds;
        return this;
    }

    @ApiModelProperty(example="null", value="IDs of conversations associated with this coaching appointment.")
    @JsonProperty(value="conversationIds")
    public List<String> getConversationIds() {
        return this.conversationIds;
    }

    public void setConversationIds(List<String> conversationIds) {
        this.conversationIds = conversationIds;
    }

    public UpdateCoachingAppointmentRequest documentIds(List<String> documentIds) {
        this.documentIds = documentIds;
        return this;
    }

    @ApiModelProperty(example="null", value="IDs of documents associated with this coaching appointment.")
    @JsonProperty(value="documentIds")
    public List<String> getDocumentIds() {
        return this.documentIds;
    }

    public void setDocumentIds(List<String> documentIds) {
        this.documentIds = documentIds;
    }

    public UpdateCoachingAppointmentRequest status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="null", value="The status of the coaching appointment.")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public UpdateCoachingAppointmentRequest wfmSchedule(WfmScheduleReference wfmSchedule) {
        this.wfmSchedule = wfmSchedule;
        return this;
    }

    @ApiModelProperty(example="null", value="The Workforce Management schedule the appointment is associated with.")
    @JsonProperty(value="wfmSchedule")
    public WfmScheduleReference getWfmSchedule() {
        return this.wfmSchedule;
    }

    public void setWfmSchedule(WfmScheduleReference wfmSchedule) {
        this.wfmSchedule = wfmSchedule;
    }

    public UpdateCoachingAppointmentRequest externalLinks(List<String> externalLinks) {
        this.externalLinks = externalLinks;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of external links related to the appointment")
    @JsonProperty(value="externalLinks")
    public List<String> getExternalLinks() {
        return this.externalLinks;
    }

    public void setExternalLinks(List<String> externalLinks) {
        this.externalLinks = externalLinks;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateCoachingAppointmentRequest updateCoachingAppointmentRequest = (UpdateCoachingAppointmentRequest)o;
        return Objects.equals(this.name, updateCoachingAppointmentRequest.name) && Objects.equals(this.description, updateCoachingAppointmentRequest.description) && Objects.equals(this.dateStart, updateCoachingAppointmentRequest.dateStart) && Objects.equals(this.lengthInMinutes, updateCoachingAppointmentRequest.lengthInMinutes) && Objects.equals(this.conversationIds, updateCoachingAppointmentRequest.conversationIds) && Objects.equals(this.documentIds, updateCoachingAppointmentRequest.documentIds) && Objects.equals((Object)this.status, (Object)updateCoachingAppointmentRequest.status) && Objects.equals(this.wfmSchedule, updateCoachingAppointmentRequest.wfmSchedule) && Objects.equals(this.externalLinks, updateCoachingAppointmentRequest.externalLinks);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.description, this.dateStart, this.lengthInMinutes, this.conversationIds, this.documentIds, this.status, this.wfmSchedule, this.externalLinks});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateCoachingAppointmentRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    dateStart: ").append(this.toIndentedString(this.dateStart)).append("\n");
        sb.append("    lengthInMinutes: ").append(this.toIndentedString(this.lengthInMinutes)).append("\n");
        sb.append("    conversationIds: ").append(this.toIndentedString(this.conversationIds)).append("\n");
        sb.append("    documentIds: ").append(this.toIndentedString(this.documentIds)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    wfmSchedule: ").append(this.toIndentedString(this.wfmSchedule)).append("\n");
        sb.append("    externalLinks: ").append(this.toIndentedString(this.externalLinks)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StatusEnumDeserializer.class)
    public static enum StatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        SCHEDULED("Scheduled"),
        INPROGRESS("InProgress"),
        COMPLETED("Completed");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StatusEnum value : StatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StatusEnumDeserializer
    extends StdDeserializer<StatusEnum> {
        public StatusEnumDeserializer() {
            super(StatusEnumDeserializer.class);
        }

        public StatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

