/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.OrgUser;
import com.mypurecloud.sdk.v2.model.Organization;
import com.mypurecloud.sdk.v2.model.TrustGroup;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class TrustRequest
implements Serializable {
    private String id = null;
    private OrgUser createdBy = null;
    private Date dateCreated = null;
    private Organization trustee = null;
    private List<OrgUser> users = null;
    private List<TrustGroup> groups = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @ApiModelProperty(example="null", value="User who created this request.")
    @JsonProperty(value="createdBy")
    public OrgUser getCreatedBy() {
        return this.createdBy;
    }

    @ApiModelProperty(example="null", value="Date request was created. There is a 48 hour expiration on all requests. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    @ApiModelProperty(example="null", required=true, value="Trustee organization who generated this request.")
    @JsonProperty(value="trustee")
    public Organization getTrustee() {
        return this.trustee;
    }

    @ApiModelProperty(example="null", value="The list of trustee users that are requesting access.")
    @JsonProperty(value="users")
    public List<OrgUser> getUsers() {
        return this.users;
    }

    @ApiModelProperty(example="null", value="The list of trustee groups that are requesting access.")
    @JsonProperty(value="groups")
    public List<TrustGroup> getGroups() {
        return this.groups;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrustRequest trustRequest = (TrustRequest)o;
        return Objects.equals(this.id, trustRequest.id) && Objects.equals(this.createdBy, trustRequest.createdBy) && Objects.equals(this.dateCreated, trustRequest.dateCreated) && Objects.equals(this.trustee, trustRequest.trustee) && Objects.equals(this.users, trustRequest.users) && Objects.equals(this.groups, trustRequest.groups) && Objects.equals(this.selfUri, trustRequest.selfUri);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.createdBy, this.dateCreated, this.trustee, this.users, this.groups, this.selfUri);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TrustRequest {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    trustee: ").append(this.toIndentedString(this.trustee)).append("\n");
        sb.append("    users: ").append(this.toIndentedString(this.users)).append("\n");
        sb.append("    groups: ").append(this.toIndentedString(this.groups)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

