/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;

public class TimeOffLimitRange
implements Serializable {
    private LocalDate startDate = null;
    private GranularityEnum granularity = null;
    private List<Integer> limitMinutesPerInterval = null;

    public TimeOffLimitRange startDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Start date of the range. The end date is determined by 'granularity' and the size of 'limitMinutesPerInterval'. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd")
    @JsonProperty(value="startDate")
    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public TimeOffLimitRange granularity(GranularityEnum granularity) {
        this.granularity = granularity;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Granularity choice for the time off limit")
    @JsonProperty(value="granularity")
    public GranularityEnum getGranularity() {
        return this.granularity;
    }

    public void setGranularity(GranularityEnum granularity) {
        this.granularity = granularity;
    }

    public TimeOffLimitRange limitMinutesPerInterval(List<Integer> limitMinutesPerInterval) {
        this.limitMinutesPerInterval = limitMinutesPerInterval;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The list of time off limit values in minutes per granularity interval. If 'null' is specified, then interval specific value is cleared. Such interval will have 'defaultLimitMinutes' value")
    @JsonProperty(value="limitMinutesPerInterval")
    public List<Integer> getLimitMinutesPerInterval() {
        return this.limitMinutesPerInterval;
    }

    public void setLimitMinutesPerInterval(List<Integer> limitMinutesPerInterval) {
        this.limitMinutesPerInterval = limitMinutesPerInterval;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeOffLimitRange timeOffLimitRange = (TimeOffLimitRange)o;
        return Objects.equals(this.startDate, timeOffLimitRange.startDate) && Objects.equals((Object)this.granularity, (Object)timeOffLimitRange.granularity) && Objects.equals(this.limitMinutesPerInterval, timeOffLimitRange.limitMinutesPerInterval);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.startDate, this.granularity, this.limitMinutesPerInterval});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TimeOffLimitRange {\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    granularity: ").append(this.toIndentedString((Object)this.granularity)).append("\n");
        sb.append("    limitMinutesPerInterval: ").append(this.toIndentedString(this.limitMinutesPerInterval)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=GranularityEnumDeserializer.class)
    public static enum GranularityEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        DAILY("Daily");

        private String value;

        private GranularityEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static GranularityEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (GranularityEnum value : GranularityEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return GranularityEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class GranularityEnumDeserializer
    extends StdDeserializer<GranularityEnum> {
        public GranularityEnumDeserializer() {
            super(GranularityEnumDeserializer.class);
        }

        public GranularityEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return GranularityEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

