/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.TextBotUserInputAlternative;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Settings for an input event to the bot flow indicating user input is available.")
public class TextBotUserInputEvent
implements Serializable {
    private ModeEnum mode = null;
    private List<TextBotUserInputAlternative> alternatives = null;

    public TextBotUserInputEvent mode(ModeEnum mode) {
        this.mode = mode;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The input mode.")
    @JsonProperty(value="mode")
    public ModeEnum getMode() {
        return this.mode;
    }

    public void setMode(ModeEnum mode) {
        this.mode = mode;
    }

    public TextBotUserInputEvent alternatives(List<TextBotUserInputAlternative> alternatives) {
        this.alternatives = alternatives;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The input alternatives.")
    @JsonProperty(value="alternatives")
    public List<TextBotUserInputAlternative> getAlternatives() {
        return this.alternatives;
    }

    public void setAlternatives(List<TextBotUserInputAlternative> alternatives) {
        this.alternatives = alternatives;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextBotUserInputEvent textBotUserInputEvent = (TextBotUserInputEvent)o;
        return Objects.equals((Object)this.mode, (Object)textBotUserInputEvent.mode) && Objects.equals(this.alternatives, textBotUserInputEvent.alternatives);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.mode, this.alternatives});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TextBotUserInputEvent {\n");
        sb.append("    mode: ").append(this.toIndentedString((Object)this.mode)).append("\n");
        sb.append("    alternatives: ").append(this.toIndentedString(this.alternatives)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ModeEnumDeserializer.class)
    public static enum ModeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        TEXT("Text");

        private String value;

        private ModeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ModeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ModeEnum value : ModeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ModeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ModeEnumDeserializer
    extends StdDeserializer<ModeEnum> {
        public ModeEnumDeserializer() {
            super(ModeEnumDeserializer.class);
        }

        public ModeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ModeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

