/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.Format;
import com.mypurecloud.sdk.v2.model.MessageContent;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Data for a single bot flow prompt segment.")
public class TextBotPromptSegment
implements Serializable {
    private String text = null;
    private TypeEnum type = null;
    private Format format = null;
    private List<MessageContent> content = null;

    public TextBotPromptSegment text(String text) {
        this.text = text;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The text of this prompt segment.")
    @JsonProperty(value="text")
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public TextBotPromptSegment type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The segment type which describes any semantics about the 'text' and also indicates which other field might include additional relevant info.")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public TextBotPromptSegment format(Format format) {
        this.format = format;
        return this;
    }

    @ApiModelProperty(example="null", value="Additional details describing the segment\u2019s contents, which the client should honour where possible.")
    @JsonProperty(value="format")
    public Format getFormat() {
        return this.format;
    }

    public void setFormat(Format format) {
        this.format = format;
    }

    public TextBotPromptSegment content(List<MessageContent> content) {
        this.content = content;
        return this;
    }

    @ApiModelProperty(example="null", value="Details to display Rich Media content. This is only populated when the segment 'type' is 'Rich Media'.")
    @JsonProperty(value="content")
    public List<MessageContent> getContent() {
        return this.content;
    }

    public void setContent(List<MessageContent> content) {
        this.content = content;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextBotPromptSegment textBotPromptSegment = (TextBotPromptSegment)o;
        return Objects.equals(this.text, textBotPromptSegment.text) && Objects.equals((Object)this.type, (Object)textBotPromptSegment.type) && Objects.equals(this.format, textBotPromptSegment.format) && Objects.equals(this.content, textBotPromptSegment.content);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.text, this.type, this.format, this.content});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TextBotPromptSegment {\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    format: ").append(this.toIndentedString(this.format)).append("\n");
        sb.append("    content: ").append(this.toIndentedString(this.content)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=TypeEnumDeserializer.class)
    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        TEXT("Text"),
        RICHMEDIA("RichMedia");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class TypeEnumDeserializer
    extends StdDeserializer<TypeEnum> {
        public TypeEnumDeserializer() {
            super(TypeEnumDeserializer.class);
        }

        public TypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

