/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.TextBotFlowLocation;
import com.mypurecloud.sdk.v2.model.TextBotFlowOutcome;
import com.mypurecloud.sdk.v2.model.TextBotInputOutputData;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Settings for a next-action of exiting the bot flow. Any output variables are available in the details.")
public class TextBotExitAction
implements Serializable {
    private ReasonEnum reason = null;
    private String reasonExtendedInfo = null;
    private String activeIntent = null;
    private TextBotFlowLocation flowLocation = null;
    private TextBotInputOutputData outputData = null;
    private List<TextBotFlowOutcome> flowOutcomes = null;

    public TextBotExitAction reason(ReasonEnum reason) {
        this.reason = reason;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The reason for the exit.")
    @JsonProperty(value="reason")
    public ReasonEnum getReason() {
        return this.reason;
    }

    public void setReason(ReasonEnum reason) {
        this.reason = reason;
    }

    public TextBotExitAction reasonExtendedInfo(String reasonExtendedInfo) {
        this.reasonExtendedInfo = reasonExtendedInfo;
        return this;
    }

    @ApiModelProperty(example="null", value="Extended information related to the reason, if available.")
    @JsonProperty(value="reasonExtendedInfo")
    public String getReasonExtendedInfo() {
        return this.reasonExtendedInfo;
    }

    public void setReasonExtendedInfo(String reasonExtendedInfo) {
        this.reasonExtendedInfo = reasonExtendedInfo;
    }

    public TextBotExitAction activeIntent(String activeIntent) {
        this.activeIntent = activeIntent;
        return this;
    }

    @ApiModelProperty(example="null", value="The active intent at the time of the exit.")
    @JsonProperty(value="activeIntent")
    public String getActiveIntent() {
        return this.activeIntent;
    }

    public void setActiveIntent(String activeIntent) {
        this.activeIntent = activeIntent;
    }

    public TextBotExitAction flowLocation(TextBotFlowLocation flowLocation) {
        this.flowLocation = flowLocation;
        return this;
    }

    @ApiModelProperty(example="null", value="Describes where in the Bot Flow the user was when the exit occurred.")
    @JsonProperty(value="flowLocation")
    public TextBotFlowLocation getFlowLocation() {
        return this.flowLocation;
    }

    public void setFlowLocation(TextBotFlowLocation flowLocation) {
        this.flowLocation = flowLocation;
    }

    public TextBotExitAction outputData(TextBotInputOutputData outputData) {
        this.outputData = outputData;
        return this;
    }

    @ApiModelProperty(example="null", value="The output data for the bot flow.")
    @JsonProperty(value="outputData")
    public TextBotInputOutputData getOutputData() {
        return this.outputData;
    }

    public void setOutputData(TextBotInputOutputData outputData) {
        this.outputData = outputData;
    }

    public TextBotExitAction flowOutcomes(List<TextBotFlowOutcome> flowOutcomes) {
        this.flowOutcomes = flowOutcomes;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of Flow Outcomes for the bot flow and their details.")
    @JsonProperty(value="flowOutcomes")
    public List<TextBotFlowOutcome> getFlowOutcomes() {
        return this.flowOutcomes;
    }

    public void setFlowOutcomes(List<TextBotFlowOutcome> flowOutcomes) {
        this.flowOutcomes = flowOutcomes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextBotExitAction textBotExitAction = (TextBotExitAction)o;
        return Objects.equals((Object)this.reason, (Object)textBotExitAction.reason) && Objects.equals(this.reasonExtendedInfo, textBotExitAction.reasonExtendedInfo) && Objects.equals(this.activeIntent, textBotExitAction.activeIntent) && Objects.equals(this.flowLocation, textBotExitAction.flowLocation) && Objects.equals(this.outputData, textBotExitAction.outputData) && Objects.equals(this.flowOutcomes, textBotExitAction.flowOutcomes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.reason, this.reasonExtendedInfo, this.activeIntent, this.flowLocation, this.outputData, this.flowOutcomes});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TextBotExitAction {\n");
        sb.append("    reason: ").append(this.toIndentedString((Object)this.reason)).append("\n");
        sb.append("    reasonExtendedInfo: ").append(this.toIndentedString(this.reasonExtendedInfo)).append("\n");
        sb.append("    activeIntent: ").append(this.toIndentedString(this.activeIntent)).append("\n");
        sb.append("    flowLocation: ").append(this.toIndentedString(this.flowLocation)).append("\n");
        sb.append("    outputData: ").append(this.toIndentedString(this.outputData)).append("\n");
        sb.append("    flowOutcomes: ").append(this.toIndentedString(this.flowOutcomes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ReasonEnumDeserializer.class)
    public static enum ReasonEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        TRIGGEREDBYUSER("TriggeredByUser"),
        AGENTREQUESTEDBYUSER("AgentRequestedByUser"),
        TRIGGEREDBYFLOW("TriggeredByFlow"),
        ERROR("Error"),
        RECOGNITIONFAILURE("RecognitionFailure");

        private String value;

        private ReasonEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ReasonEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ReasonEnum value : ReasonEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ReasonEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ReasonEnumDeserializer
    extends StdDeserializer<ReasonEnum> {
        public ReasonEnumDeserializer() {
            super(ReasonEnumDeserializer.class);
        }

        public ReasonEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ReasonEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

