/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.LocalDateRange;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;

public class QueryTimeOffLimitValuesRequest
implements Serializable {
    private String timeOffLimitId = null;
    private String activityCodeId = null;
    private List<LocalDateRange> dateRanges = null;

    public QueryTimeOffLimitValuesRequest timeOffLimitId(String timeOffLimitId) {
        this.timeOffLimitId = timeOffLimitId;
        return this;
    }

    @ApiModelProperty(example="null", value="The time off limit object id to retrieve values for. Required if activityCodeId is not specified")
    @JsonProperty(value="timeOffLimitId")
    public String getTimeOffLimitId() {
        return this.timeOffLimitId;
    }

    public void setTimeOffLimitId(String timeOffLimitId) {
        this.timeOffLimitId = timeOffLimitId;
    }

    public QueryTimeOffLimitValuesRequest activityCodeId(String activityCodeId) {
        this.activityCodeId = activityCodeId;
        return this;
    }

    @ApiModelProperty(example="null", value="The activity code id to filter the affected limit objects by. Required if timeOffLimitId is not specified")
    @JsonProperty(value="activityCodeId")
    public String getActivityCodeId() {
        return this.activityCodeId;
    }

    public void setActivityCodeId(String activityCodeId) {
        this.activityCodeId = activityCodeId;
    }

    public QueryTimeOffLimitValuesRequest dateRanges(List<LocalDateRange> dateRanges) {
        this.dateRanges = dateRanges;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The list of the date ranges to return time off limit, allocated and waitlisted minutes. The valid number of date ranges is between 1 and 30. Maximum total number of days in all ranges in 366.")
    @JsonProperty(value="dateRanges")
    public List<LocalDateRange> getDateRanges() {
        return this.dateRanges;
    }

    public void setDateRanges(List<LocalDateRange> dateRanges) {
        this.dateRanges = dateRanges;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryTimeOffLimitValuesRequest queryTimeOffLimitValuesRequest = (QueryTimeOffLimitValuesRequest)o;
        return Objects.equals(this.timeOffLimitId, queryTimeOffLimitValuesRequest.timeOffLimitId) && Objects.equals(this.activityCodeId, queryTimeOffLimitValuesRequest.activityCodeId) && Objects.equals(this.dateRanges, queryTimeOffLimitValuesRequest.dateRanges);
    }

    public int hashCode() {
        return Objects.hash(this.timeOffLimitId, this.activityCodeId, this.dateRanges);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class QueryTimeOffLimitValuesRequest {\n");
        sb.append("    timeOffLimitId: ").append(this.toIndentedString(this.timeOffLimitId)).append("\n");
        sb.append("    activityCodeId: ").append(this.toIndentedString(this.activityCodeId)).append("\n");
        sb.append("    dateRanges: ").append(this.toIndentedString(this.dateRanges)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

