/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.AnalyticsProperty;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class PropertyIndexRequest
implements Serializable {
    private String sessionId = null;
    private Date targetDate = null;
    private List<AnalyticsProperty> properties = null;

    public PropertyIndexRequest sessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Attach properties to a segment in the indicated session")
    @JsonProperty(value="sessionId")
    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public PropertyIndexRequest targetDate(Date targetDate) {
        this.targetDate = targetDate;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Attach properties to a segment covering a specific point in time. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="targetDate")
    public Date getTargetDate() {
        return this.targetDate;
    }

    public void setTargetDate(Date targetDate) {
        this.targetDate = targetDate;
    }

    public PropertyIndexRequest properties(List<AnalyticsProperty> properties) {
        this.properties = properties;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The list of properties to index")
    @JsonProperty(value="properties")
    public List<AnalyticsProperty> getProperties() {
        return this.properties;
    }

    public void setProperties(List<AnalyticsProperty> properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyIndexRequest propertyIndexRequest = (PropertyIndexRequest)o;
        return Objects.equals(this.sessionId, propertyIndexRequest.sessionId) && Objects.equals(this.targetDate, propertyIndexRequest.targetDate) && Objects.equals(this.properties, propertyIndexRequest.properties);
    }

    public int hashCode() {
        return Objects.hash(this.sessionId, this.targetDate, this.properties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PropertyIndexRequest {\n");
        sb.append("    sessionId: ").append(this.toIndentedString(this.sessionId)).append("\n");
        sb.append("    targetDate: ").append(this.toIndentedString(this.targetDate)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

