/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.FacebookScopedId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;

@ApiModel(description="User information for a Facebook user interacting with a page or app")
public class FacebookId
implements Serializable {
    private List<FacebookScopedId> ids = null;
    private String displayName = null;

    public FacebookId ids(List<FacebookScopedId> ids) {
        this.ids = ids;
        return this;
    }

    @ApiModelProperty(example="null", value="The set of scopedIds that this person has. Each scopedId is specific to a page or app that the user interacts with.")
    @JsonProperty(value="ids")
    public List<FacebookScopedId> getIds() {
        return this.ids;
    }

    public void setIds(List<FacebookScopedId> ids) {
        this.ids = ids;
    }

    public FacebookId displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @ApiModelProperty(example="null", value="The displayName of this person's Facebook account. Roughly translates to user.first_name + ' ' + user.last_name in the Facebook API.")
    @JsonProperty(value="displayName")
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FacebookId facebookId = (FacebookId)o;
        return Objects.equals(this.ids, facebookId.ids) && Objects.equals(this.displayName, facebookId.displayName);
    }

    public int hashCode() {
        return Objects.hash(this.ids, this.displayName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FacebookId {\n");
        sb.append("    ids: ").append(this.toIndentedString(this.ids)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

