/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.Attachment;
import com.mypurecloud.sdk.v2.model.ConversationRoutingData;
import com.mypurecloud.sdk.v2.model.DomainEntityRef;
import com.mypurecloud.sdk.v2.model.ErrorInfo;
import com.mypurecloud.sdk.v2.model.JourneyContext;
import com.mypurecloud.sdk.v2.model.Wrapup;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class EmailMediaParticipant
implements Serializable {
    private String id = null;
    private String name = null;
    private String address = null;
    private Date startTime = null;
    private Date connectedTime = null;
    private Date endTime = null;
    private Date startHoldTime = null;
    private String purpose = null;
    private StateEnum state = null;
    private DirectionEnum direction = null;
    private DisconnectTypeEnum disconnectType = null;
    private Boolean held = null;
    private Boolean wrapupRequired = null;
    private String wrapupPrompt = null;
    private DomainEntityRef user = null;
    private DomainEntityRef queue = null;
    private DomainEntityRef team = null;
    private Map<String, String> attributes = null;
    private ErrorInfo errorInfo = null;
    private DomainEntityRef script = null;
    private Integer wrapupTimeoutMs = null;
    private Boolean wrapupSkipped = null;
    private Integer alertingTimeoutMs = null;
    private String provider = null;
    private DomainEntityRef externalContact = null;
    private DomainEntityRef externalOrganization = null;
    private Wrapup wrapup = null;
    private String peer = null;
    private FlaggedReasonEnum flaggedReason = null;
    private JourneyContext journeyContext = null;
    private ConversationRoutingData conversationRoutingData = null;
    private Date startAcwTime = null;
    private Date endAcwTime = null;
    private String subject = null;
    private Integer messagesSent = null;
    private Boolean autoGenerated = null;
    private List<Attachment> draftAttachments = null;
    private Boolean spam = null;
    private String messageId = null;

    public EmailMediaParticipant id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="The unique participant ID.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public EmailMediaParticipant name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="The display friendly name of the participant.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public EmailMediaParticipant address(String address) {
        this.address = address;
        return this;
    }

    @ApiModelProperty(example="null", value="The participant address.")
    @JsonProperty(value="address")
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public EmailMediaParticipant startTime(Date startTime) {
        this.startTime = startTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The time when this participant first joined the conversation. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="startTime")
    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public EmailMediaParticipant connectedTime(Date connectedTime) {
        this.connectedTime = connectedTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The time when this participant went connected for this media (eg: video connected time). Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="connectedTime")
    public Date getConnectedTime() {
        return this.connectedTime;
    }

    public void setConnectedTime(Date connectedTime) {
        this.connectedTime = connectedTime;
    }

    public EmailMediaParticipant endTime(Date endTime) {
        this.endTime = endTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The time when this participant went disconnected for this media (eg: video disconnected time). Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="endTime")
    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public EmailMediaParticipant startHoldTime(Date startHoldTime) {
        this.startHoldTime = startHoldTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The time when this participant's hold started. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="startHoldTime")
    public Date getStartHoldTime() {
        return this.startHoldTime;
    }

    public void setStartHoldTime(Date startHoldTime) {
        this.startHoldTime = startHoldTime;
    }

    public EmailMediaParticipant purpose(String purpose) {
        this.purpose = purpose;
        return this;
    }

    @ApiModelProperty(example="null", value="The participant's purpose.  Values can be: 'agent', 'user', 'customer', 'external', 'acd', 'ivr")
    @JsonProperty(value="purpose")
    public String getPurpose() {
        return this.purpose;
    }

    public void setPurpose(String purpose) {
        this.purpose = purpose;
    }

    public EmailMediaParticipant state(StateEnum state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(example="null", value="The participant's state.  Values can be: 'alerting', 'connected', 'disconnected', 'dialing', 'contacting")
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public EmailMediaParticipant direction(DirectionEnum direction) {
        this.direction = direction;
        return this;
    }

    @ApiModelProperty(example="null", value="The participant's direction.  Values can be: 'inbound' or 'outbound'")
    @JsonProperty(value="direction")
    public DirectionEnum getDirection() {
        return this.direction;
    }

    public void setDirection(DirectionEnum direction) {
        this.direction = direction;
    }

    public EmailMediaParticipant disconnectType(DisconnectTypeEnum disconnectType) {
        this.disconnectType = disconnectType;
        return this;
    }

    @ApiModelProperty(example="null", value="The reason the participant was disconnected from the conversation.")
    @JsonProperty(value="disconnectType")
    public DisconnectTypeEnum getDisconnectType() {
        return this.disconnectType;
    }

    public void setDisconnectType(DisconnectTypeEnum disconnectType) {
        this.disconnectType = disconnectType;
    }

    public EmailMediaParticipant held(Boolean held) {
        this.held = held;
        return this;
    }

    @ApiModelProperty(example="null", value="Value is true when the participant is on hold.")
    @JsonProperty(value="held")
    public Boolean getHeld() {
        return this.held;
    }

    public void setHeld(Boolean held) {
        this.held = held;
    }

    public EmailMediaParticipant wrapupRequired(Boolean wrapupRequired) {
        this.wrapupRequired = wrapupRequired;
        return this;
    }

    @ApiModelProperty(example="null", value="Value is true when the participant requires wrap-up.")
    @JsonProperty(value="wrapupRequired")
    public Boolean getWrapupRequired() {
        return this.wrapupRequired;
    }

    public void setWrapupRequired(Boolean wrapupRequired) {
        this.wrapupRequired = wrapupRequired;
    }

    public EmailMediaParticipant wrapupPrompt(String wrapupPrompt) {
        this.wrapupPrompt = wrapupPrompt;
        return this;
    }

    @ApiModelProperty(example="null", value="The wrap-up prompt indicating the type of wrap-up to be performed.")
    @JsonProperty(value="wrapupPrompt")
    public String getWrapupPrompt() {
        return this.wrapupPrompt;
    }

    public void setWrapupPrompt(String wrapupPrompt) {
        this.wrapupPrompt = wrapupPrompt;
    }

    public EmailMediaParticipant user(DomainEntityRef user) {
        this.user = user;
        return this;
    }

    @ApiModelProperty(example="null", value="The PureCloud user for this participant.")
    @JsonProperty(value="user")
    public DomainEntityRef getUser() {
        return this.user;
    }

    public void setUser(DomainEntityRef user) {
        this.user = user;
    }

    public EmailMediaParticipant queue(DomainEntityRef queue) {
        this.queue = queue;
        return this;
    }

    @ApiModelProperty(example="null", value="The PureCloud queue for this participant.")
    @JsonProperty(value="queue")
    public DomainEntityRef getQueue() {
        return this.queue;
    }

    public void setQueue(DomainEntityRef queue) {
        this.queue = queue;
    }

    public EmailMediaParticipant team(DomainEntityRef team) {
        this.team = team;
        return this;
    }

    @ApiModelProperty(example="null", value="The PureCloud team for this participant.")
    @JsonProperty(value="team")
    public DomainEntityRef getTeam() {
        return this.team;
    }

    public void setTeam(DomainEntityRef team) {
        this.team = team;
    }

    public EmailMediaParticipant attributes(Map<String, String> attributes) {
        this.attributes = attributes;
        return this;
    }

    @ApiModelProperty(example="null", value="A list of ad-hoc attributes for the participant.")
    @JsonProperty(value="attributes")
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public EmailMediaParticipant errorInfo(ErrorInfo errorInfo) {
        this.errorInfo = errorInfo;
        return this;
    }

    @ApiModelProperty(example="null", value="If the conversation ends in error, contains additional error details.")
    @JsonProperty(value="errorInfo")
    public ErrorInfo getErrorInfo() {
        return this.errorInfo;
    }

    public void setErrorInfo(ErrorInfo errorInfo) {
        this.errorInfo = errorInfo;
    }

    public EmailMediaParticipant script(DomainEntityRef script) {
        this.script = script;
        return this;
    }

    @ApiModelProperty(example="null", value="The Engage script that should be used by this participant.")
    @JsonProperty(value="script")
    public DomainEntityRef getScript() {
        return this.script;
    }

    public void setScript(DomainEntityRef script) {
        this.script = script;
    }

    public EmailMediaParticipant wrapupTimeoutMs(Integer wrapupTimeoutMs) {
        this.wrapupTimeoutMs = wrapupTimeoutMs;
        return this;
    }

    @ApiModelProperty(example="null", value="The amount of time the participant has to complete wrap-up.")
    @JsonProperty(value="wrapupTimeoutMs")
    public Integer getWrapupTimeoutMs() {
        return this.wrapupTimeoutMs;
    }

    public void setWrapupTimeoutMs(Integer wrapupTimeoutMs) {
        this.wrapupTimeoutMs = wrapupTimeoutMs;
    }

    public EmailMediaParticipant wrapupSkipped(Boolean wrapupSkipped) {
        this.wrapupSkipped = wrapupSkipped;
        return this;
    }

    @ApiModelProperty(example="null", value="Value is true when the participant has skipped wrap-up.")
    @JsonProperty(value="wrapupSkipped")
    public Boolean getWrapupSkipped() {
        return this.wrapupSkipped;
    }

    public void setWrapupSkipped(Boolean wrapupSkipped) {
        this.wrapupSkipped = wrapupSkipped;
    }

    public EmailMediaParticipant alertingTimeoutMs(Integer alertingTimeoutMs) {
        this.alertingTimeoutMs = alertingTimeoutMs;
        return this;
    }

    @ApiModelProperty(example="null", value="Specifies how long the agent has to answer an interaction before being marked as not responding.")
    @JsonProperty(value="alertingTimeoutMs")
    public Integer getAlertingTimeoutMs() {
        return this.alertingTimeoutMs;
    }

    public void setAlertingTimeoutMs(Integer alertingTimeoutMs) {
        this.alertingTimeoutMs = alertingTimeoutMs;
    }

    public EmailMediaParticipant provider(String provider) {
        this.provider = provider;
        return this;
    }

    @ApiModelProperty(example="null", value="The source provider for the communication.")
    @JsonProperty(value="provider")
    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public EmailMediaParticipant externalContact(DomainEntityRef externalContact) {
        this.externalContact = externalContact;
        return this;
    }

    @ApiModelProperty(example="null", value="If this participant represents an external contact, then this will be the reference for the external contact.")
    @JsonProperty(value="externalContact")
    public DomainEntityRef getExternalContact() {
        return this.externalContact;
    }

    public void setExternalContact(DomainEntityRef externalContact) {
        this.externalContact = externalContact;
    }

    public EmailMediaParticipant externalOrganization(DomainEntityRef externalOrganization) {
        this.externalOrganization = externalOrganization;
        return this;
    }

    @ApiModelProperty(example="null", value="If this participant represents an external org, then this will be the reference for the external org.")
    @JsonProperty(value="externalOrganization")
    public DomainEntityRef getExternalOrganization() {
        return this.externalOrganization;
    }

    public void setExternalOrganization(DomainEntityRef externalOrganization) {
        this.externalOrganization = externalOrganization;
    }

    public EmailMediaParticipant wrapup(Wrapup wrapup) {
        this.wrapup = wrapup;
        return this;
    }

    @ApiModelProperty(example="null", value="Wrapup for this participant, if it has been applied.")
    @JsonProperty(value="wrapup")
    public Wrapup getWrapup() {
        return this.wrapup;
    }

    public void setWrapup(Wrapup wrapup) {
        this.wrapup = wrapup;
    }

    public EmailMediaParticipant peer(String peer) {
        this.peer = peer;
        return this;
    }

    @ApiModelProperty(example="null", value="The peer communication corresponding to a matching leg for this communication.")
    @JsonProperty(value="peer")
    public String getPeer() {
        return this.peer;
    }

    public void setPeer(String peer) {
        this.peer = peer;
    }

    public EmailMediaParticipant flaggedReason(FlaggedReasonEnum flaggedReason) {
        this.flaggedReason = flaggedReason;
        return this;
    }

    @ApiModelProperty(example="null", value="The reason specifying why participant flagged the conversation.")
    @JsonProperty(value="flaggedReason")
    public FlaggedReasonEnum getFlaggedReason() {
        return this.flaggedReason;
    }

    public void setFlaggedReason(FlaggedReasonEnum flaggedReason) {
        this.flaggedReason = flaggedReason;
    }

    public EmailMediaParticipant journeyContext(JourneyContext journeyContext) {
        this.journeyContext = journeyContext;
        return this;
    }

    @ApiModelProperty(example="null", value="Journey System data/context that is applicable to this communication.  When used for historical purposes, the context should be immutable.  When null, there is no applicable Journey System context.")
    @JsonProperty(value="journeyContext")
    public JourneyContext getJourneyContext() {
        return this.journeyContext;
    }

    public void setJourneyContext(JourneyContext journeyContext) {
        this.journeyContext = journeyContext;
    }

    public EmailMediaParticipant conversationRoutingData(ConversationRoutingData conversationRoutingData) {
        this.conversationRoutingData = conversationRoutingData;
        return this;
    }

    @ApiModelProperty(example="null", value="Information on how a communication should be routed to an agent.")
    @JsonProperty(value="conversationRoutingData")
    public ConversationRoutingData getConversationRoutingData() {
        return this.conversationRoutingData;
    }

    public void setConversationRoutingData(ConversationRoutingData conversationRoutingData) {
        this.conversationRoutingData = conversationRoutingData;
    }

    public EmailMediaParticipant startAcwTime(Date startAcwTime) {
        this.startAcwTime = startAcwTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The timestamp when this participant started after-call work. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="startAcwTime")
    public Date getStartAcwTime() {
        return this.startAcwTime;
    }

    public void setStartAcwTime(Date startAcwTime) {
        this.startAcwTime = startAcwTime;
    }

    public EmailMediaParticipant endAcwTime(Date endAcwTime) {
        this.endAcwTime = endAcwTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The timestamp when this participant ended after-call work. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="endAcwTime")
    public Date getEndAcwTime() {
        return this.endAcwTime;
    }

    public void setEndAcwTime(Date endAcwTime) {
        this.endAcwTime = endAcwTime;
    }

    public EmailMediaParticipant subject(String subject) {
        this.subject = subject;
        return this;
    }

    @ApiModelProperty(example="null", value="The subject of the email.")
    @JsonProperty(value="subject")
    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public EmailMediaParticipant messagesSent(Integer messagesSent) {
        this.messagesSent = messagesSent;
        return this;
    }

    @ApiModelProperty(example="null", value="The number of messages that have been sent in this email conversation.")
    @JsonProperty(value="messagesSent")
    public Integer getMessagesSent() {
        return this.messagesSent;
    }

    public void setMessagesSent(Integer messagesSent) {
        this.messagesSent = messagesSent;
    }

    public EmailMediaParticipant autoGenerated(Boolean autoGenerated) {
        this.autoGenerated = autoGenerated;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates that the email was auto-generated like an Out of Office reply.")
    @JsonProperty(value="autoGenerated")
    public Boolean getAutoGenerated() {
        return this.autoGenerated;
    }

    public void setAutoGenerated(Boolean autoGenerated) {
        this.autoGenerated = autoGenerated;
    }

    public EmailMediaParticipant draftAttachments(List<Attachment> draftAttachments) {
        this.draftAttachments = draftAttachments;
        return this;
    }

    @ApiModelProperty(example="null", value="A list of uploaded attachments on the email draft.")
    @JsonProperty(value="draftAttachments")
    public List<Attachment> getDraftAttachments() {
        return this.draftAttachments;
    }

    public void setDraftAttachments(List<Attachment> draftAttachments) {
        this.draftAttachments = draftAttachments;
    }

    public EmailMediaParticipant spam(Boolean spam) {
        this.spam = spam;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates if the inbound email was marked as spam.")
    @JsonProperty(value="spam")
    public Boolean getSpam() {
        return this.spam;
    }

    public void setSpam(Boolean spam) {
        this.spam = spam;
    }

    public EmailMediaParticipant messageId(String messageId) {
        this.messageId = messageId;
        return this;
    }

    @ApiModelProperty(example="null", value="A globally unique identifier for the stored content of this communication.")
    @JsonProperty(value="messageId")
    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmailMediaParticipant emailMediaParticipant = (EmailMediaParticipant)o;
        return Objects.equals(this.id, emailMediaParticipant.id) && Objects.equals(this.name, emailMediaParticipant.name) && Objects.equals(this.address, emailMediaParticipant.address) && Objects.equals(this.startTime, emailMediaParticipant.startTime) && Objects.equals(this.connectedTime, emailMediaParticipant.connectedTime) && Objects.equals(this.endTime, emailMediaParticipant.endTime) && Objects.equals(this.startHoldTime, emailMediaParticipant.startHoldTime) && Objects.equals(this.purpose, emailMediaParticipant.purpose) && Objects.equals((Object)this.state, (Object)emailMediaParticipant.state) && Objects.equals((Object)this.direction, (Object)emailMediaParticipant.direction) && Objects.equals((Object)this.disconnectType, (Object)emailMediaParticipant.disconnectType) && Objects.equals(this.held, emailMediaParticipant.held) && Objects.equals(this.wrapupRequired, emailMediaParticipant.wrapupRequired) && Objects.equals(this.wrapupPrompt, emailMediaParticipant.wrapupPrompt) && Objects.equals(this.user, emailMediaParticipant.user) && Objects.equals(this.queue, emailMediaParticipant.queue) && Objects.equals(this.team, emailMediaParticipant.team) && Objects.equals(this.attributes, emailMediaParticipant.attributes) && Objects.equals(this.errorInfo, emailMediaParticipant.errorInfo) && Objects.equals(this.script, emailMediaParticipant.script) && Objects.equals(this.wrapupTimeoutMs, emailMediaParticipant.wrapupTimeoutMs) && Objects.equals(this.wrapupSkipped, emailMediaParticipant.wrapupSkipped) && Objects.equals(this.alertingTimeoutMs, emailMediaParticipant.alertingTimeoutMs) && Objects.equals(this.provider, emailMediaParticipant.provider) && Objects.equals(this.externalContact, emailMediaParticipant.externalContact) && Objects.equals(this.externalOrganization, emailMediaParticipant.externalOrganization) && Objects.equals(this.wrapup, emailMediaParticipant.wrapup) && Objects.equals(this.peer, emailMediaParticipant.peer) && Objects.equals((Object)this.flaggedReason, (Object)emailMediaParticipant.flaggedReason) && Objects.equals(this.journeyContext, emailMediaParticipant.journeyContext) && Objects.equals(this.conversationRoutingData, emailMediaParticipant.conversationRoutingData) && Objects.equals(this.startAcwTime, emailMediaParticipant.startAcwTime) && Objects.equals(this.endAcwTime, emailMediaParticipant.endAcwTime) && Objects.equals(this.subject, emailMediaParticipant.subject) && Objects.equals(this.messagesSent, emailMediaParticipant.messagesSent) && Objects.equals(this.autoGenerated, emailMediaParticipant.autoGenerated) && Objects.equals(this.draftAttachments, emailMediaParticipant.draftAttachments) && Objects.equals(this.spam, emailMediaParticipant.spam) && Objects.equals(this.messageId, emailMediaParticipant.messageId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.address, this.startTime, this.connectedTime, this.endTime, this.startHoldTime, this.purpose, this.state, this.direction, this.disconnectType, this.held, this.wrapupRequired, this.wrapupPrompt, this.user, this.queue, this.team, this.attributes, this.errorInfo, this.script, this.wrapupTimeoutMs, this.wrapupSkipped, this.alertingTimeoutMs, this.provider, this.externalContact, this.externalOrganization, this.wrapup, this.peer, this.flaggedReason, this.journeyContext, this.conversationRoutingData, this.startAcwTime, this.endAcwTime, this.subject, this.messagesSent, this.autoGenerated, this.draftAttachments, this.spam, this.messageId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EmailMediaParticipant {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    startTime: ").append(this.toIndentedString(this.startTime)).append("\n");
        sb.append("    connectedTime: ").append(this.toIndentedString(this.connectedTime)).append("\n");
        sb.append("    endTime: ").append(this.toIndentedString(this.endTime)).append("\n");
        sb.append("    startHoldTime: ").append(this.toIndentedString(this.startHoldTime)).append("\n");
        sb.append("    purpose: ").append(this.toIndentedString(this.purpose)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    direction: ").append(this.toIndentedString((Object)this.direction)).append("\n");
        sb.append("    disconnectType: ").append(this.toIndentedString((Object)this.disconnectType)).append("\n");
        sb.append("    held: ").append(this.toIndentedString(this.held)).append("\n");
        sb.append("    wrapupRequired: ").append(this.toIndentedString(this.wrapupRequired)).append("\n");
        sb.append("    wrapupPrompt: ").append(this.toIndentedString(this.wrapupPrompt)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    queue: ").append(this.toIndentedString(this.queue)).append("\n");
        sb.append("    team: ").append(this.toIndentedString(this.team)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    errorInfo: ").append(this.toIndentedString(this.errorInfo)).append("\n");
        sb.append("    script: ").append(this.toIndentedString(this.script)).append("\n");
        sb.append("    wrapupTimeoutMs: ").append(this.toIndentedString(this.wrapupTimeoutMs)).append("\n");
        sb.append("    wrapupSkipped: ").append(this.toIndentedString(this.wrapupSkipped)).append("\n");
        sb.append("    alertingTimeoutMs: ").append(this.toIndentedString(this.alertingTimeoutMs)).append("\n");
        sb.append("    provider: ").append(this.toIndentedString(this.provider)).append("\n");
        sb.append("    externalContact: ").append(this.toIndentedString(this.externalContact)).append("\n");
        sb.append("    externalOrganization: ").append(this.toIndentedString(this.externalOrganization)).append("\n");
        sb.append("    wrapup: ").append(this.toIndentedString(this.wrapup)).append("\n");
        sb.append("    peer: ").append(this.toIndentedString(this.peer)).append("\n");
        sb.append("    flaggedReason: ").append(this.toIndentedString((Object)this.flaggedReason)).append("\n");
        sb.append("    journeyContext: ").append(this.toIndentedString(this.journeyContext)).append("\n");
        sb.append("    conversationRoutingData: ").append(this.toIndentedString(this.conversationRoutingData)).append("\n");
        sb.append("    startAcwTime: ").append(this.toIndentedString(this.startAcwTime)).append("\n");
        sb.append("    endAcwTime: ").append(this.toIndentedString(this.endAcwTime)).append("\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("    messagesSent: ").append(this.toIndentedString(this.messagesSent)).append("\n");
        sb.append("    autoGenerated: ").append(this.toIndentedString(this.autoGenerated)).append("\n");
        sb.append("    draftAttachments: ").append(this.toIndentedString(this.draftAttachments)).append("\n");
        sb.append("    spam: ").append(this.toIndentedString(this.spam)).append("\n");
        sb.append("    messageId: ").append(this.toIndentedString(this.messageId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=FlaggedReasonEnumDeserializer.class)
    public static enum FlaggedReasonEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        GENERAL("general");

        private String value;

        private FlaggedReasonEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static FlaggedReasonEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (FlaggedReasonEnum value : FlaggedReasonEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return FlaggedReasonEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class FlaggedReasonEnumDeserializer
    extends StdDeserializer<FlaggedReasonEnum> {
        public FlaggedReasonEnumDeserializer() {
            super(FlaggedReasonEnumDeserializer.class);
        }

        public FlaggedReasonEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return FlaggedReasonEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=DisconnectTypeEnumDeserializer.class)
    public static enum DisconnectTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ENDPOINT("endpoint"),
        CLIENT("client"),
        SYSTEM("system"),
        TRANSFER("transfer"),
        TRANSFER_CONFERENCE("transfer.conference"),
        TRANSFER_CONSULT("transfer.consult"),
        TRANSFER_FORWARD("transfer.forward"),
        TRANSFER_NOANSWER("transfer.noanswer"),
        TRANSFER_NOTAVAILABLE("transfer.notavailable"),
        TRANSPORT_FAILURE("transport.failure"),
        ERROR("error"),
        PEER("peer"),
        OTHER("other"),
        SPAM("spam");

        private String value;

        private DisconnectTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DisconnectTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (DisconnectTypeEnum value : DisconnectTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return DisconnectTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class DisconnectTypeEnumDeserializer
    extends StdDeserializer<DisconnectTypeEnum> {
        public DisconnectTypeEnumDeserializer() {
            super(DisconnectTypeEnumDeserializer.class);
        }

        public DisconnectTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return DisconnectTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=DirectionEnumDeserializer.class)
    public static enum DirectionEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        INBOUND("inbound"),
        OUTBOUND("outbound");

        private String value;

        private DirectionEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DirectionEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (DirectionEnum value : DirectionEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return DirectionEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class DirectionEnumDeserializer
    extends StdDeserializer<DirectionEnum> {
        public DirectionEnumDeserializer() {
            super(DirectionEnumDeserializer.class);
        }

        public DirectionEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return DirectionEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=StateEnumDeserializer.class)
    public static enum StateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ALERTING("alerting"),
        DIALING("dialing"),
        CONTACTING("contacting"),
        OFFERING("offering"),
        CONNECTED("connected"),
        DISCONNECTED("disconnected"),
        TERMINATED("terminated"),
        CONVERTING("converting"),
        UPLOADING("uploading"),
        TRANSMITTING("transmitting"),
        NONE("none");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateEnum value : StateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StateEnumDeserializer
    extends StdDeserializer<StateEnum> {
        public StateEnumDeserializer() {
            super(StateEnumDeserializer.class);
        }

        public StateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StateEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

