/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Specifies the requirements for a credential that can be provided for configuring an integration")
public class CredentialSpecification
implements Serializable {
    private Boolean required = null;
    private String title = null;
    private List<String> credentialTypes = null;

    @ApiModelProperty(example="null", value="Indicates if the credential must be provided in order for the integration configuration to be valid.")
    @JsonProperty(value="required")
    public Boolean getRequired() {
        return this.required;
    }

    @ApiModelProperty(example="null", value="Title describing the usage for this credential.")
    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    @ApiModelProperty(example="null", value="List of acceptable credential types that can be provided for this credential.")
    @JsonProperty(value="credentialTypes")
    public List<String> getCredentialTypes() {
        return this.credentialTypes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CredentialSpecification credentialSpecification = (CredentialSpecification)o;
        return Objects.equals(this.required, credentialSpecification.required) && Objects.equals(this.title, credentialSpecification.title) && Objects.equals(this.credentialTypes, credentialSpecification.credentialTypes);
    }

    public int hashCode() {
        return Objects.hash(this.required, this.title, this.credentialTypes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CredentialSpecification {\n");
        sb.append("    required: ").append(this.toIndentedString(this.required)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    credentialTypes: ").append(this.toIndentedString(this.credentialTypes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

