/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;

public class CreateTimeOffPlanRequest
implements Serializable {
    private String name = null;
    private List<String> activityCodeIds = null;
    private List<String> timeOffLimitIds = null;
    private AutoApprovalRuleEnum autoApprovalRule = null;
    private Integer daysBeforeStartToExpireFromWaitlist = null;
    private Boolean active = null;

    public CreateTimeOffPlanRequest name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of this time off plan.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CreateTimeOffPlanRequest activityCodeIds(List<String> activityCodeIds) {
        this.activityCodeIds = activityCodeIds;
        return this;
    }

    @ApiModelProperty(example="null", value="The set of activity code IDs to associate with this time off plan.")
    @JsonProperty(value="activityCodeIds")
    public List<String> getActivityCodeIds() {
        return this.activityCodeIds;
    }

    public void setActivityCodeIds(List<String> activityCodeIds) {
        this.activityCodeIds = activityCodeIds;
    }

    public CreateTimeOffPlanRequest timeOffLimitIds(List<String> timeOffLimitIds) {
        this.timeOffLimitIds = timeOffLimitIds;
        return this;
    }

    @ApiModelProperty(example="null", value="The set of time off limit IDs to associate with this time off plan.")
    @JsonProperty(value="timeOffLimitIds")
    public List<String> getTimeOffLimitIds() {
        return this.timeOffLimitIds;
    }

    public void setTimeOffLimitIds(List<String> timeOffLimitIds) {
        this.timeOffLimitIds = timeOffLimitIds;
    }

    public CreateTimeOffPlanRequest autoApprovalRule(AutoApprovalRuleEnum autoApprovalRule) {
        this.autoApprovalRule = autoApprovalRule;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Auto approval rule for the time off plan.")
    @JsonProperty(value="autoApprovalRule")
    public AutoApprovalRuleEnum getAutoApprovalRule() {
        return this.autoApprovalRule;
    }

    public void setAutoApprovalRule(AutoApprovalRuleEnum autoApprovalRule) {
        this.autoApprovalRule = autoApprovalRule;
    }

    public CreateTimeOffPlanRequest daysBeforeStartToExpireFromWaitlist(Integer daysBeforeStartToExpireFromWaitlist) {
        this.daysBeforeStartToExpireFromWaitlist = daysBeforeStartToExpireFromWaitlist;
        return this;
    }

    @ApiModelProperty(example="null", value="The number of days before the time off request start date for when the request will be expired from the waitlist.")
    @JsonProperty(value="daysBeforeStartToExpireFromWaitlist")
    public Integer getDaysBeforeStartToExpireFromWaitlist() {
        return this.daysBeforeStartToExpireFromWaitlist;
    }

    public void setDaysBeforeStartToExpireFromWaitlist(Integer daysBeforeStartToExpireFromWaitlist) {
        this.daysBeforeStartToExpireFromWaitlist = daysBeforeStartToExpireFromWaitlist;
    }

    public CreateTimeOffPlanRequest active(Boolean active) {
        this.active = active;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Whether this time off plan should be used by agents.")
    @JsonProperty(value="active")
    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateTimeOffPlanRequest createTimeOffPlanRequest = (CreateTimeOffPlanRequest)o;
        return Objects.equals(this.name, createTimeOffPlanRequest.name) && Objects.equals(this.activityCodeIds, createTimeOffPlanRequest.activityCodeIds) && Objects.equals(this.timeOffLimitIds, createTimeOffPlanRequest.timeOffLimitIds) && Objects.equals((Object)this.autoApprovalRule, (Object)createTimeOffPlanRequest.autoApprovalRule) && Objects.equals(this.daysBeforeStartToExpireFromWaitlist, createTimeOffPlanRequest.daysBeforeStartToExpireFromWaitlist) && Objects.equals(this.active, createTimeOffPlanRequest.active);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.activityCodeIds, this.timeOffLimitIds, this.autoApprovalRule, this.daysBeforeStartToExpireFromWaitlist, this.active});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateTimeOffPlanRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    activityCodeIds: ").append(this.toIndentedString(this.activityCodeIds)).append("\n");
        sb.append("    timeOffLimitIds: ").append(this.toIndentedString(this.timeOffLimitIds)).append("\n");
        sb.append("    autoApprovalRule: ").append(this.toIndentedString((Object)this.autoApprovalRule)).append("\n");
        sb.append("    daysBeforeStartToExpireFromWaitlist: ").append(this.toIndentedString(this.daysBeforeStartToExpireFromWaitlist)).append("\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=AutoApprovalRuleEnumDeserializer.class)
    public static enum AutoApprovalRuleEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        NEVER("Never"),
        ALWAYS("Always"),
        CHECKLIMITS("CheckLimits");

        private String value;

        private AutoApprovalRuleEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static AutoApprovalRuleEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (AutoApprovalRuleEnum value : AutoApprovalRuleEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return AutoApprovalRuleEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class AutoApprovalRuleEnumDeserializer
    extends StdDeserializer<AutoApprovalRuleEnum> {
        public AutoApprovalRuleEnumDeserializer() {
            super(AutoApprovalRuleEnumDeserializer.class);
        }

        public AutoApprovalRuleEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return AutoApprovalRuleEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

