/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.Campaign;
import com.mypurecloud.sdk.v2.model.ExternalContact;
import com.mypurecloud.sdk.v2.model.ExternalOrganization;
import com.mypurecloud.sdk.v2.model.Group;
import com.mypurecloud.sdk.v2.model.Queue;
import com.mypurecloud.sdk.v2.model.User;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class CallHistoryParticipant
implements Serializable {
    private String id = null;
    private String name = null;
    private String address = null;
    private Date startTime = null;
    private Date endTime = null;
    private String purpose = null;
    private DirectionEnum direction = null;
    private String ani = null;
    private String dnis = null;
    private User user = null;
    private Queue queue = null;
    private Group group = null;
    private DisconnectTypeEnum disconnectType = null;
    private ExternalContact externalContact = null;
    private ExternalOrganization externalOrganization = null;
    private Boolean didInteract = null;
    private List<Long> sipResponseCodes = null;
    private FlaggedReasonEnum flaggedReason = null;
    private Campaign outboundCampaign = null;

    public CallHistoryParticipant id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="The unique participant ID.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public CallHistoryParticipant name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="The display friendly name of the participant.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CallHistoryParticipant address(String address) {
        this.address = address;
        return this;
    }

    @ApiModelProperty(example="null", value="The participant address.")
    @JsonProperty(value="address")
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public CallHistoryParticipant startTime(Date startTime) {
        this.startTime = startTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The time when this participant first joined the conversation. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="startTime")
    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public CallHistoryParticipant endTime(Date endTime) {
        this.endTime = endTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The time when this participant went disconnected for this media (eg: video disconnected time). Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="endTime")
    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public CallHistoryParticipant purpose(String purpose) {
        this.purpose = purpose;
        return this;
    }

    @ApiModelProperty(example="null", value="The participant's purpose.  Values can be: 'agent', 'user', 'customer', 'external', 'acd', 'ivr")
    @JsonProperty(value="purpose")
    public String getPurpose() {
        return this.purpose;
    }

    public void setPurpose(String purpose) {
        this.purpose = purpose;
    }

    public CallHistoryParticipant direction(DirectionEnum direction) {
        this.direction = direction;
        return this;
    }

    @ApiModelProperty(example="null", value="The participant's direction.  Values can be: 'inbound' or 'outbound'")
    @JsonProperty(value="direction")
    public DirectionEnum getDirection() {
        return this.direction;
    }

    public void setDirection(DirectionEnum direction) {
        this.direction = direction;
    }

    public CallHistoryParticipant ani(String ani) {
        this.ani = ani;
        return this;
    }

    @ApiModelProperty(example="null", value="The call ANI.")
    @JsonProperty(value="ani")
    public String getAni() {
        return this.ani;
    }

    public void setAni(String ani) {
        this.ani = ani;
    }

    public CallHistoryParticipant dnis(String dnis) {
        this.dnis = dnis;
        return this;
    }

    @ApiModelProperty(example="null", value="The call DNIS.")
    @JsonProperty(value="dnis")
    public String getDnis() {
        return this.dnis;
    }

    public void setDnis(String dnis) {
        this.dnis = dnis;
    }

    public CallHistoryParticipant user(User user) {
        this.user = user;
        return this;
    }

    @ApiModelProperty(example="null", value="The PureCloud user for this participant.")
    @JsonProperty(value="user")
    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public CallHistoryParticipant queue(Queue queue) {
        this.queue = queue;
        return this;
    }

    @ApiModelProperty(example="null", value="The PureCloud queue for this participant.")
    @JsonProperty(value="queue")
    public Queue getQueue() {
        return this.queue;
    }

    public void setQueue(Queue queue) {
        this.queue = queue;
    }

    public CallHistoryParticipant group(Group group) {
        this.group = group;
        return this;
    }

    @ApiModelProperty(example="null", value="The group involved in the group ring call.")
    @JsonProperty(value="group")
    public Group getGroup() {
        return this.group;
    }

    public void setGroup(Group group) {
        this.group = group;
    }

    public CallHistoryParticipant disconnectType(DisconnectTypeEnum disconnectType) {
        this.disconnectType = disconnectType;
        return this;
    }

    @ApiModelProperty(example="null", value="The reason the participant was disconnected from the conversation.")
    @JsonProperty(value="disconnectType")
    public DisconnectTypeEnum getDisconnectType() {
        return this.disconnectType;
    }

    public void setDisconnectType(DisconnectTypeEnum disconnectType) {
        this.disconnectType = disconnectType;
    }

    public CallHistoryParticipant externalContact(ExternalContact externalContact) {
        this.externalContact = externalContact;
        return this;
    }

    @ApiModelProperty(example="null", value="The PureCloud external contact")
    @JsonProperty(value="externalContact")
    public ExternalContact getExternalContact() {
        return this.externalContact;
    }

    public void setExternalContact(ExternalContact externalContact) {
        this.externalContact = externalContact;
    }

    public CallHistoryParticipant externalOrganization(ExternalOrganization externalOrganization) {
        this.externalOrganization = externalOrganization;
        return this;
    }

    @ApiModelProperty(example="null", value="The PureCloud external organization")
    @JsonProperty(value="externalOrganization")
    public ExternalOrganization getExternalOrganization() {
        return this.externalOrganization;
    }

    public void setExternalOrganization(ExternalOrganization externalOrganization) {
        this.externalOrganization = externalOrganization;
    }

    public CallHistoryParticipant didInteract(Boolean didInteract) {
        this.didInteract = didInteract;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates whether the contact ever connected")
    @JsonProperty(value="didInteract")
    public Boolean getDidInteract() {
        return this.didInteract;
    }

    public void setDidInteract(Boolean didInteract) {
        this.didInteract = didInteract;
    }

    public CallHistoryParticipant sipResponseCodes(List<Long> sipResponseCodes) {
        this.sipResponseCodes = sipResponseCodes;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates SIP Response codes associated with the participant")
    @JsonProperty(value="sipResponseCodes")
    public List<Long> getSipResponseCodes() {
        return this.sipResponseCodes;
    }

    public void setSipResponseCodes(List<Long> sipResponseCodes) {
        this.sipResponseCodes = sipResponseCodes;
    }

    public CallHistoryParticipant flaggedReason(FlaggedReasonEnum flaggedReason) {
        this.flaggedReason = flaggedReason;
        return this;
    }

    @ApiModelProperty(example="null", value="The reason specifying why participant flagged the conversation.")
    @JsonProperty(value="flaggedReason")
    public FlaggedReasonEnum getFlaggedReason() {
        return this.flaggedReason;
    }

    public void setFlaggedReason(FlaggedReasonEnum flaggedReason) {
        this.flaggedReason = flaggedReason;
    }

    public CallHistoryParticipant outboundCampaign(Campaign outboundCampaign) {
        this.outboundCampaign = outboundCampaign;
        return this;
    }

    @ApiModelProperty(example="null", value="The outbound campaign associated with the participant")
    @JsonProperty(value="outboundCampaign")
    public Campaign getOutboundCampaign() {
        return this.outboundCampaign;
    }

    public void setOutboundCampaign(Campaign outboundCampaign) {
        this.outboundCampaign = outboundCampaign;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CallHistoryParticipant callHistoryParticipant = (CallHistoryParticipant)o;
        return Objects.equals(this.id, callHistoryParticipant.id) && Objects.equals(this.name, callHistoryParticipant.name) && Objects.equals(this.address, callHistoryParticipant.address) && Objects.equals(this.startTime, callHistoryParticipant.startTime) && Objects.equals(this.endTime, callHistoryParticipant.endTime) && Objects.equals(this.purpose, callHistoryParticipant.purpose) && Objects.equals((Object)this.direction, (Object)callHistoryParticipant.direction) && Objects.equals(this.ani, callHistoryParticipant.ani) && Objects.equals(this.dnis, callHistoryParticipant.dnis) && Objects.equals(this.user, callHistoryParticipant.user) && Objects.equals(this.queue, callHistoryParticipant.queue) && Objects.equals(this.group, callHistoryParticipant.group) && Objects.equals((Object)this.disconnectType, (Object)callHistoryParticipant.disconnectType) && Objects.equals(this.externalContact, callHistoryParticipant.externalContact) && Objects.equals(this.externalOrganization, callHistoryParticipant.externalOrganization) && Objects.equals(this.didInteract, callHistoryParticipant.didInteract) && Objects.equals(this.sipResponseCodes, callHistoryParticipant.sipResponseCodes) && Objects.equals((Object)this.flaggedReason, (Object)callHistoryParticipant.flaggedReason) && Objects.equals(this.outboundCampaign, callHistoryParticipant.outboundCampaign);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.address, this.startTime, this.endTime, this.purpose, this.direction, this.ani, this.dnis, this.user, this.queue, this.group, this.disconnectType, this.externalContact, this.externalOrganization, this.didInteract, this.sipResponseCodes, this.flaggedReason, this.outboundCampaign});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CallHistoryParticipant {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    startTime: ").append(this.toIndentedString(this.startTime)).append("\n");
        sb.append("    endTime: ").append(this.toIndentedString(this.endTime)).append("\n");
        sb.append("    purpose: ").append(this.toIndentedString(this.purpose)).append("\n");
        sb.append("    direction: ").append(this.toIndentedString((Object)this.direction)).append("\n");
        sb.append("    ani: ").append(this.toIndentedString(this.ani)).append("\n");
        sb.append("    dnis: ").append(this.toIndentedString(this.dnis)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    queue: ").append(this.toIndentedString(this.queue)).append("\n");
        sb.append("    group: ").append(this.toIndentedString(this.group)).append("\n");
        sb.append("    disconnectType: ").append(this.toIndentedString((Object)this.disconnectType)).append("\n");
        sb.append("    externalContact: ").append(this.toIndentedString(this.externalContact)).append("\n");
        sb.append("    externalOrganization: ").append(this.toIndentedString(this.externalOrganization)).append("\n");
        sb.append("    didInteract: ").append(this.toIndentedString(this.didInteract)).append("\n");
        sb.append("    sipResponseCodes: ").append(this.toIndentedString(this.sipResponseCodes)).append("\n");
        sb.append("    flaggedReason: ").append(this.toIndentedString((Object)this.flaggedReason)).append("\n");
        sb.append("    outboundCampaign: ").append(this.toIndentedString(this.outboundCampaign)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=FlaggedReasonEnumDeserializer.class)
    public static enum FlaggedReasonEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        GENERAL("general");

        private String value;

        private FlaggedReasonEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static FlaggedReasonEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (FlaggedReasonEnum value : FlaggedReasonEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return FlaggedReasonEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class FlaggedReasonEnumDeserializer
    extends StdDeserializer<FlaggedReasonEnum> {
        public FlaggedReasonEnumDeserializer() {
            super(FlaggedReasonEnumDeserializer.class);
        }

        public FlaggedReasonEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return FlaggedReasonEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=DisconnectTypeEnumDeserializer.class)
    public static enum DisconnectTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ENDPOINT("endpoint"),
        CLIENT("client"),
        SYSTEM("system"),
        TRANSFER("transfer"),
        TRANSFER_CONFERENCE("transfer.conference"),
        TRANSFER_CONSULT("transfer.consult"),
        TRANSFER_FORWARD("transfer.forward"),
        TRANSFER_NOANSWER("transfer.noanswer"),
        TRANSFER_NOTAVAILABLE("transfer.notavailable"),
        TRANSPORT_FAILURE("transport.failure"),
        ERROR("error"),
        PEER("peer"),
        OTHER("other"),
        SPAM("spam");

        private String value;

        private DisconnectTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DisconnectTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (DisconnectTypeEnum value : DisconnectTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return DisconnectTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class DisconnectTypeEnumDeserializer
    extends StdDeserializer<DisconnectTypeEnum> {
        public DisconnectTypeEnumDeserializer() {
            super(DisconnectTypeEnumDeserializer.class);
        }

        public DisconnectTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return DisconnectTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=DirectionEnumDeserializer.class)
    public static enum DirectionEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        INBOUND("inbound"),
        OUTBOUND("outbound");

        private String value;

        private DirectionEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DirectionEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (DirectionEnum value : DirectionEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return DirectionEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class DirectionEnumDeserializer
    extends StdDeserializer<DirectionEnum> {
        public DirectionEnumDeserializer() {
            super(DirectionEnumDeserializer.class);
        }

        public DirectionEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return DirectionEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

