/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.Address;
import com.mypurecloud.sdk.v2.model.AfterCallWork;
import com.mypurecloud.sdk.v2.model.DisconnectReason;
import com.mypurecloud.sdk.v2.model.ErrorInfo;
import com.mypurecloud.sdk.v2.model.FaxStatus;
import com.mypurecloud.sdk.v2.model.Segment;
import com.mypurecloud.sdk.v2.model.Wrapup;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class Call
implements Serializable {
    private StateEnum state = null;
    private String id = null;
    private DirectionEnum direction = null;
    private Boolean recording = null;
    private RecordingStateEnum recordingState = null;
    private Boolean muted = null;
    private Boolean confined = null;
    private Boolean held = null;
    private String recordingId = null;
    private List<Segment> segments = null;
    private ErrorInfo errorInfo = null;
    private DisconnectTypeEnum disconnectType = null;
    private Date startHoldTime = null;
    private String documentId = null;
    private Date startAlertingTime = null;
    private Date connectedTime = null;
    private Date disconnectedTime = null;
    private List<DisconnectReason> disconnectReasons = null;
    private FaxStatus faxStatus = null;
    private String provider = null;
    private String scriptId = null;
    private String peerId = null;
    private String uuiData = null;
    private Address self = null;
    private Address other = null;
    private Wrapup wrapup = null;
    private AfterCallWork afterCallWork = null;
    private Boolean afterCallWorkRequired = null;
    private String agentAssistantId = null;
    private InitialStateEnum initialState = null;

    public Call state(StateEnum state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(example="null", value="The connection state of this communication.")
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public Call id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="A globally unique identifier for this communication.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Call direction(DirectionEnum direction) {
        this.direction = direction;
        return this;
    }

    @ApiModelProperty(example="null", value="The direction of the call")
    @JsonProperty(value="direction")
    public DirectionEnum getDirection() {
        return this.direction;
    }

    public void setDirection(DirectionEnum direction) {
        this.direction = direction;
    }

    public Call recording(Boolean recording) {
        this.recording = recording;
        return this;
    }

    @ApiModelProperty(example="null", value="True if this call is being recorded.")
    @JsonProperty(value="recording")
    public Boolean getRecording() {
        return this.recording;
    }

    public void setRecording(Boolean recording) {
        this.recording = recording;
    }

    public Call recordingState(RecordingStateEnum recordingState) {
        this.recordingState = recordingState;
        return this;
    }

    @ApiModelProperty(example="null", value="State of recording on this call.")
    @JsonProperty(value="recordingState")
    public RecordingStateEnum getRecordingState() {
        return this.recordingState;
    }

    public void setRecordingState(RecordingStateEnum recordingState) {
        this.recordingState = recordingState;
    }

    public Call muted(Boolean muted) {
        this.muted = muted;
        return this;
    }

    @ApiModelProperty(example="null", value="True if this call is muted so that remote participants can't hear any audio from this end.")
    @JsonProperty(value="muted")
    public Boolean getMuted() {
        return this.muted;
    }

    public void setMuted(Boolean muted) {
        this.muted = muted;
    }

    public Call confined(Boolean confined) {
        this.confined = confined;
        return this;
    }

    @ApiModelProperty(example="null", value="True if this call is held and the person on this side hears hold music.")
    @JsonProperty(value="confined")
    public Boolean getConfined() {
        return this.confined;
    }

    public void setConfined(Boolean confined) {
        this.confined = confined;
    }

    public Call held(Boolean held) {
        this.held = held;
        return this;
    }

    @ApiModelProperty(example="null", value="True if this call is held and the person on this side hears silence.")
    @JsonProperty(value="held")
    public Boolean getHeld() {
        return this.held;
    }

    public void setHeld(Boolean held) {
        this.held = held;
    }

    public Call recordingId(String recordingId) {
        this.recordingId = recordingId;
        return this;
    }

    @ApiModelProperty(example="null", value="A globally unique identifier for the recording associated with this call.")
    @JsonProperty(value="recordingId")
    public String getRecordingId() {
        return this.recordingId;
    }

    public void setRecordingId(String recordingId) {
        this.recordingId = recordingId;
    }

    public Call segments(List<Segment> segments) {
        this.segments = segments;
        return this;
    }

    @ApiModelProperty(example="null", value="The time line of the participant's call, divided into activity segments.")
    @JsonProperty(value="segments")
    public List<Segment> getSegments() {
        return this.segments;
    }

    public void setSegments(List<Segment> segments) {
        this.segments = segments;
    }

    public Call errorInfo(ErrorInfo errorInfo) {
        this.errorInfo = errorInfo;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="errorInfo")
    public ErrorInfo getErrorInfo() {
        return this.errorInfo;
    }

    public void setErrorInfo(ErrorInfo errorInfo) {
        this.errorInfo = errorInfo;
    }

    public Call disconnectType(DisconnectTypeEnum disconnectType) {
        this.disconnectType = disconnectType;
        return this;
    }

    @ApiModelProperty(example="null", value="System defined string indicating what caused the communication to disconnect. Will be null until the communication disconnects.")
    @JsonProperty(value="disconnectType")
    public DisconnectTypeEnum getDisconnectType() {
        return this.disconnectType;
    }

    public void setDisconnectType(DisconnectTypeEnum disconnectType) {
        this.disconnectType = disconnectType;
    }

    public Call startHoldTime(Date startHoldTime) {
        this.startHoldTime = startHoldTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The timestamp the call was placed on hold in the cloud clock if the call is currently on hold. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="startHoldTime")
    public Date getStartHoldTime() {
        return this.startHoldTime;
    }

    public void setStartHoldTime(Date startHoldTime) {
        this.startHoldTime = startHoldTime;
    }

    public Call documentId(String documentId) {
        this.documentId = documentId;
        return this;
    }

    @ApiModelProperty(example="null", value="If call is an outbound fax of a document from content management, then this is the id in content management.")
    @JsonProperty(value="documentId")
    public String getDocumentId() {
        return this.documentId;
    }

    public void setDocumentId(String documentId) {
        this.documentId = documentId;
    }

    public Call startAlertingTime(Date startAlertingTime) {
        this.startAlertingTime = startAlertingTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The timestamp the communication has when it is first put into an alerting state. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="startAlertingTime")
    public Date getStartAlertingTime() {
        return this.startAlertingTime;
    }

    public void setStartAlertingTime(Date startAlertingTime) {
        this.startAlertingTime = startAlertingTime;
    }

    public Call connectedTime(Date connectedTime) {
        this.connectedTime = connectedTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The timestamp when this communication was connected in the cloud clock. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="connectedTime")
    public Date getConnectedTime() {
        return this.connectedTime;
    }

    public void setConnectedTime(Date connectedTime) {
        this.connectedTime = connectedTime;
    }

    public Call disconnectedTime(Date disconnectedTime) {
        this.disconnectedTime = disconnectedTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The timestamp when this communication disconnected from the conversation in the provider clock. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="disconnectedTime")
    public Date getDisconnectedTime() {
        return this.disconnectedTime;
    }

    public void setDisconnectedTime(Date disconnectedTime) {
        this.disconnectedTime = disconnectedTime;
    }

    public Call disconnectReasons(List<DisconnectReason> disconnectReasons) {
        this.disconnectReasons = disconnectReasons;
        return this;
    }

    @ApiModelProperty(example="null", value="List of reasons that this call was disconnected. This will be set once the call disconnects.")
    @JsonProperty(value="disconnectReasons")
    public List<DisconnectReason> getDisconnectReasons() {
        return this.disconnectReasons;
    }

    public void setDisconnectReasons(List<DisconnectReason> disconnectReasons) {
        this.disconnectReasons = disconnectReasons;
    }

    public Call faxStatus(FaxStatus faxStatus) {
        this.faxStatus = faxStatus;
        return this;
    }

    @ApiModelProperty(example="null", value="Extra information on fax transmission.")
    @JsonProperty(value="faxStatus")
    public FaxStatus getFaxStatus() {
        return this.faxStatus;
    }

    public void setFaxStatus(FaxStatus faxStatus) {
        this.faxStatus = faxStatus;
    }

    public Call provider(String provider) {
        this.provider = provider;
        return this;
    }

    @ApiModelProperty(example="null", value="The source provider for the call.")
    @JsonProperty(value="provider")
    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public Call scriptId(String scriptId) {
        this.scriptId = scriptId;
        return this;
    }

    @ApiModelProperty(example="null", value="The UUID of the script to use.")
    @JsonProperty(value="scriptId")
    public String getScriptId() {
        return this.scriptId;
    }

    public void setScriptId(String scriptId) {
        this.scriptId = scriptId;
    }

    public Call peerId(String peerId) {
        this.peerId = peerId;
        return this;
    }

    @ApiModelProperty(example="null", value="The id of the peer communication corresponding to a matching leg for this communication.")
    @JsonProperty(value="peerId")
    public String getPeerId() {
        return this.peerId;
    }

    public void setPeerId(String peerId) {
        this.peerId = peerId;
    }

    public Call uuiData(String uuiData) {
        this.uuiData = uuiData;
        return this;
    }

    @ApiModelProperty(example="null", value="User to User Information (UUI) data managed by SIP session application.")
    @JsonProperty(value="uuiData")
    public String getUuiData() {
        return this.uuiData;
    }

    public void setUuiData(String uuiData) {
        this.uuiData = uuiData;
    }

    public Call self(Address self) {
        this.self = self;
        return this;
    }

    @ApiModelProperty(example="null", value="Address and name data for a call endpoint.")
    @JsonProperty(value="self")
    public Address getSelf() {
        return this.self;
    }

    public void setSelf(Address self) {
        this.self = self;
    }

    public Call other(Address other) {
        this.other = other;
        return this;
    }

    @ApiModelProperty(example="null", value="Address and name data for a call endpoint.")
    @JsonProperty(value="other")
    public Address getOther() {
        return this.other;
    }

    public void setOther(Address other) {
        this.other = other;
    }

    public Call wrapup(Wrapup wrapup) {
        this.wrapup = wrapup;
        return this;
    }

    @ApiModelProperty(example="null", value="Call wrap up or disposition data.")
    @JsonProperty(value="wrapup")
    public Wrapup getWrapup() {
        return this.wrapup;
    }

    public void setWrapup(Wrapup wrapup) {
        this.wrapup = wrapup;
    }

    public Call afterCallWork(AfterCallWork afterCallWork) {
        this.afterCallWork = afterCallWork;
        return this;
    }

    @ApiModelProperty(example="null", value="After-call work for the communication.")
    @JsonProperty(value="afterCallWork")
    public AfterCallWork getAfterCallWork() {
        return this.afterCallWork;
    }

    public void setAfterCallWork(AfterCallWork afterCallWork) {
        this.afterCallWork = afterCallWork;
    }

    public Call afterCallWorkRequired(Boolean afterCallWorkRequired) {
        this.afterCallWorkRequired = afterCallWorkRequired;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates if after-call work is required for a communication. Only used when the ACW Setting is Agent Requested.")
    @JsonProperty(value="afterCallWorkRequired")
    public Boolean getAfterCallWorkRequired() {
        return this.afterCallWorkRequired;
    }

    public void setAfterCallWorkRequired(Boolean afterCallWorkRequired) {
        this.afterCallWorkRequired = afterCallWorkRequired;
    }

    public Call agentAssistantId(String agentAssistantId) {
        this.agentAssistantId = agentAssistantId;
        return this;
    }

    @ApiModelProperty(example="null", value="UUID of virtual agent assistant that provide suggestions to the agent participant during the conversation.")
    @JsonProperty(value="agentAssistantId")
    public String getAgentAssistantId() {
        return this.agentAssistantId;
    }

    public void setAgentAssistantId(String agentAssistantId) {
        this.agentAssistantId = agentAssistantId;
    }

    public Call initialState(InitialStateEnum initialState) {
        this.initialState = initialState;
        return this;
    }

    @ApiModelProperty(example="null", value="The initial connection state of this communication.")
    @JsonProperty(value="initialState")
    public InitialStateEnum getInitialState() {
        return this.initialState;
    }

    public void setInitialState(InitialStateEnum initialState) {
        this.initialState = initialState;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Call call = (Call)o;
        return Objects.equals((Object)this.state, (Object)call.state) && Objects.equals(this.id, call.id) && Objects.equals((Object)this.direction, (Object)call.direction) && Objects.equals(this.recording, call.recording) && Objects.equals((Object)this.recordingState, (Object)call.recordingState) && Objects.equals(this.muted, call.muted) && Objects.equals(this.confined, call.confined) && Objects.equals(this.held, call.held) && Objects.equals(this.recordingId, call.recordingId) && Objects.equals(this.segments, call.segments) && Objects.equals(this.errorInfo, call.errorInfo) && Objects.equals((Object)this.disconnectType, (Object)call.disconnectType) && Objects.equals(this.startHoldTime, call.startHoldTime) && Objects.equals(this.documentId, call.documentId) && Objects.equals(this.startAlertingTime, call.startAlertingTime) && Objects.equals(this.connectedTime, call.connectedTime) && Objects.equals(this.disconnectedTime, call.disconnectedTime) && Objects.equals(this.disconnectReasons, call.disconnectReasons) && Objects.equals(this.faxStatus, call.faxStatus) && Objects.equals(this.provider, call.provider) && Objects.equals(this.scriptId, call.scriptId) && Objects.equals(this.peerId, call.peerId) && Objects.equals(this.uuiData, call.uuiData) && Objects.equals(this.self, call.self) && Objects.equals(this.other, call.other) && Objects.equals(this.wrapup, call.wrapup) && Objects.equals(this.afterCallWork, call.afterCallWork) && Objects.equals(this.afterCallWorkRequired, call.afterCallWorkRequired) && Objects.equals(this.agentAssistantId, call.agentAssistantId) && Objects.equals((Object)this.initialState, (Object)call.initialState);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.state, this.id, this.direction, this.recording, this.recordingState, this.muted, this.confined, this.held, this.recordingId, this.segments, this.errorInfo, this.disconnectType, this.startHoldTime, this.documentId, this.startAlertingTime, this.connectedTime, this.disconnectedTime, this.disconnectReasons, this.faxStatus, this.provider, this.scriptId, this.peerId, this.uuiData, this.self, this.other, this.wrapup, this.afterCallWork, this.afterCallWorkRequired, this.agentAssistantId, this.initialState});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Call {\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    direction: ").append(this.toIndentedString((Object)this.direction)).append("\n");
        sb.append("    recording: ").append(this.toIndentedString(this.recording)).append("\n");
        sb.append("    recordingState: ").append(this.toIndentedString((Object)this.recordingState)).append("\n");
        sb.append("    muted: ").append(this.toIndentedString(this.muted)).append("\n");
        sb.append("    confined: ").append(this.toIndentedString(this.confined)).append("\n");
        sb.append("    held: ").append(this.toIndentedString(this.held)).append("\n");
        sb.append("    recordingId: ").append(this.toIndentedString(this.recordingId)).append("\n");
        sb.append("    segments: ").append(this.toIndentedString(this.segments)).append("\n");
        sb.append("    errorInfo: ").append(this.toIndentedString(this.errorInfo)).append("\n");
        sb.append("    disconnectType: ").append(this.toIndentedString((Object)this.disconnectType)).append("\n");
        sb.append("    startHoldTime: ").append(this.toIndentedString(this.startHoldTime)).append("\n");
        sb.append("    documentId: ").append(this.toIndentedString(this.documentId)).append("\n");
        sb.append("    startAlertingTime: ").append(this.toIndentedString(this.startAlertingTime)).append("\n");
        sb.append("    connectedTime: ").append(this.toIndentedString(this.connectedTime)).append("\n");
        sb.append("    disconnectedTime: ").append(this.toIndentedString(this.disconnectedTime)).append("\n");
        sb.append("    disconnectReasons: ").append(this.toIndentedString(this.disconnectReasons)).append("\n");
        sb.append("    faxStatus: ").append(this.toIndentedString(this.faxStatus)).append("\n");
        sb.append("    provider: ").append(this.toIndentedString(this.provider)).append("\n");
        sb.append("    scriptId: ").append(this.toIndentedString(this.scriptId)).append("\n");
        sb.append("    peerId: ").append(this.toIndentedString(this.peerId)).append("\n");
        sb.append("    uuiData: ").append(this.toIndentedString(this.uuiData)).append("\n");
        sb.append("    self: ").append(this.toIndentedString(this.self)).append("\n");
        sb.append("    other: ").append(this.toIndentedString(this.other)).append("\n");
        sb.append("    wrapup: ").append(this.toIndentedString(this.wrapup)).append("\n");
        sb.append("    afterCallWork: ").append(this.toIndentedString(this.afterCallWork)).append("\n");
        sb.append("    afterCallWorkRequired: ").append(this.toIndentedString(this.afterCallWorkRequired)).append("\n");
        sb.append("    agentAssistantId: ").append(this.toIndentedString(this.agentAssistantId)).append("\n");
        sb.append("    initialState: ").append(this.toIndentedString((Object)this.initialState)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=InitialStateEnumDeserializer.class)
    public static enum InitialStateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ALERTING("alerting"),
        DIALING("dialing"),
        CONTACTING("contacting"),
        OFFERING("offering"),
        CONNECTED("connected"),
        DISCONNECTED("disconnected"),
        TERMINATED("terminated"),
        CONVERTING("converting"),
        UPLOADING("uploading"),
        TRANSMITTING("transmitting"),
        NONE("none");

        private String value;

        private InitialStateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static InitialStateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (InitialStateEnum value : InitialStateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return InitialStateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class InitialStateEnumDeserializer
    extends StdDeserializer<InitialStateEnum> {
        public InitialStateEnumDeserializer() {
            super(InitialStateEnumDeserializer.class);
        }

        public InitialStateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return InitialStateEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=DisconnectTypeEnumDeserializer.class)
    public static enum DisconnectTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ENDPOINT("endpoint"),
        CLIENT("client"),
        SYSTEM("system"),
        TIMEOUT("timeout"),
        TRANSFER("transfer"),
        TRANSFER_CONFERENCE("transfer.conference"),
        TRANSFER_CONSULT("transfer.consult"),
        TRANSFER_FORWARD("transfer.forward"),
        TRANSFER_NOANSWER("transfer.noanswer"),
        TRANSFER_NOTAVAILABLE("transfer.notavailable"),
        TRANSPORT_FAILURE("transport.failure"),
        ERROR("error"),
        PEER("peer"),
        OTHER("other"),
        SPAM("spam"),
        UNCALLABLE("uncallable");

        private String value;

        private DisconnectTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DisconnectTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (DisconnectTypeEnum value : DisconnectTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return DisconnectTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class DisconnectTypeEnumDeserializer
    extends StdDeserializer<DisconnectTypeEnum> {
        public DisconnectTypeEnumDeserializer() {
            super(DisconnectTypeEnumDeserializer.class);
        }

        public DisconnectTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return DisconnectTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=RecordingStateEnumDeserializer.class)
    public static enum RecordingStateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        NONE("none"),
        ACTIVE("active"),
        PAUSED("paused");

        private String value;

        private RecordingStateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static RecordingStateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (RecordingStateEnum value : RecordingStateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return RecordingStateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class RecordingStateEnumDeserializer
    extends StdDeserializer<RecordingStateEnum> {
        public RecordingStateEnumDeserializer() {
            super(RecordingStateEnumDeserializer.class);
        }

        public RecordingStateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return RecordingStateEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=DirectionEnumDeserializer.class)
    public static enum DirectionEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        INBOUND("inbound"),
        OUTBOUND("outbound");

        private String value;

        private DirectionEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DirectionEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (DirectionEnum value : DirectionEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return DirectionEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class DirectionEnumDeserializer
    extends StdDeserializer<DirectionEnum> {
        public DirectionEnumDeserializer() {
            super(DirectionEnumDeserializer.class);
        }

        public DirectionEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return DirectionEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=StateEnumDeserializer.class)
    public static enum StateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ALERTING("alerting"),
        DIALING("dialing"),
        CONTACTING("contacting"),
        OFFERING("offering"),
        CONNECTED("connected"),
        DISCONNECTED("disconnected"),
        TERMINATED("terminated"),
        CONVERTING("converting"),
        UPLOADING("uploading"),
        TRANSMITTING("transmitting"),
        NONE("none");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateEnum value : StateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StateEnumDeserializer
    extends StdDeserializer<StateEnum> {
        public StateEnumDeserializer() {
            super(StateEnumDeserializer.class);
        }

        public StateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StateEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

