/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.BuScheduleReference;
import com.mypurecloud.sdk.v2.model.ReschedulingOptionsRunResponse;
import com.mypurecloud.sdk.v2.model.SchedulerMessageSeverityCount;
import com.mypurecloud.sdk.v2.model.UserReference;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class BuScheduleRun
implements Serializable {
    private String id = null;
    private String schedulerRunId = null;
    private Boolean intradayRescheduling = null;
    private StateEnum state = null;
    private Integer weekCount = null;
    private Double percentComplete = null;
    private LocalDate targetWeek = null;
    private BuScheduleReference schedule = null;
    private String scheduleDescription = null;
    private Date schedulingStartTime = null;
    private UserReference schedulingStartedBy = null;
    private UserReference schedulingCanceledBy = null;
    private Date schedulingCompletedTime = null;
    private Integer messageCount = null;
    private List<SchedulerMessageSeverityCount> messageSeverityCounts = null;
    private ReschedulingOptionsRunResponse reschedulingOptions = null;
    private Date reschedulingResultExpiration = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public BuScheduleRun schedulerRunId(String schedulerRunId) {
        this.schedulerRunId = schedulerRunId;
        return this;
    }

    @ApiModelProperty(example="null", value="The scheduler run ID.  Reference this value for support")
    @JsonProperty(value="schedulerRunId")
    public String getSchedulerRunId() {
        return this.schedulerRunId;
    }

    public void setSchedulerRunId(String schedulerRunId) {
        this.schedulerRunId = schedulerRunId;
    }

    public BuScheduleRun intradayRescheduling(Boolean intradayRescheduling) {
        this.intradayRescheduling = intradayRescheduling;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether this is an intraday rescheduling run")
    @JsonProperty(value="intradayRescheduling")
    public Boolean getIntradayRescheduling() {
        return this.intradayRescheduling;
    }

    public void setIntradayRescheduling(Boolean intradayRescheduling) {
        this.intradayRescheduling = intradayRescheduling;
    }

    public BuScheduleRun state(StateEnum state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(example="null", value="The state of the generation run")
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public BuScheduleRun weekCount(Integer weekCount) {
        this.weekCount = weekCount;
        return this;
    }

    @ApiModelProperty(example="null", value="The number of weeks spanned by the schedule")
    @JsonProperty(value="weekCount")
    public Integer getWeekCount() {
        return this.weekCount;
    }

    public void setWeekCount(Integer weekCount) {
        this.weekCount = weekCount;
    }

    public BuScheduleRun percentComplete(Double percentComplete) {
        this.percentComplete = percentComplete;
        return this;
    }

    @ApiModelProperty(example="null", value="Percent completion of the schedule run")
    @JsonProperty(value="percentComplete")
    public Double getPercentComplete() {
        return this.percentComplete;
    }

    public void setPercentComplete(Double percentComplete) {
        this.percentComplete = percentComplete;
    }

    public BuScheduleRun targetWeek(LocalDate targetWeek) {
        this.targetWeek = targetWeek;
        return this;
    }

    @ApiModelProperty(example="null", value="The start date of the target week. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd")
    @JsonProperty(value="targetWeek")
    public LocalDate getTargetWeek() {
        return this.targetWeek;
    }

    public void setTargetWeek(LocalDate targetWeek) {
        this.targetWeek = targetWeek;
    }

    public BuScheduleRun schedule(BuScheduleReference schedule) {
        this.schedule = schedule;
        return this;
    }

    @ApiModelProperty(example="null", value="The generated schedule.  Null unless the schedule run is complete")
    @JsonProperty(value="schedule")
    public BuScheduleReference getSchedule() {
        return this.schedule;
    }

    public void setSchedule(BuScheduleReference schedule) {
        this.schedule = schedule;
    }

    public BuScheduleRun scheduleDescription(String scheduleDescription) {
        this.scheduleDescription = scheduleDescription;
        return this;
    }

    @ApiModelProperty(example="null", value="The description of the generated schedule")
    @JsonProperty(value="scheduleDescription")
    public String getScheduleDescription() {
        return this.scheduleDescription;
    }

    public void setScheduleDescription(String scheduleDescription) {
        this.scheduleDescription = scheduleDescription;
    }

    public BuScheduleRun schedulingStartTime(Date schedulingStartTime) {
        this.schedulingStartTime = schedulingStartTime;
        return this;
    }

    @ApiModelProperty(example="null", value="When the schedule generation run started. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="schedulingStartTime")
    public Date getSchedulingStartTime() {
        return this.schedulingStartTime;
    }

    public void setSchedulingStartTime(Date schedulingStartTime) {
        this.schedulingStartTime = schedulingStartTime;
    }

    public BuScheduleRun schedulingStartedBy(UserReference schedulingStartedBy) {
        this.schedulingStartedBy = schedulingStartedBy;
        return this;
    }

    @ApiModelProperty(example="null", value="The user who started the scheduling run")
    @JsonProperty(value="schedulingStartedBy")
    public UserReference getSchedulingStartedBy() {
        return this.schedulingStartedBy;
    }

    public void setSchedulingStartedBy(UserReference schedulingStartedBy) {
        this.schedulingStartedBy = schedulingStartedBy;
    }

    public BuScheduleRun schedulingCanceledBy(UserReference schedulingCanceledBy) {
        this.schedulingCanceledBy = schedulingCanceledBy;
        return this;
    }

    @ApiModelProperty(example="null", value="The user who canceled the scheduling run, if applicable")
    @JsonProperty(value="schedulingCanceledBy")
    public UserReference getSchedulingCanceledBy() {
        return this.schedulingCanceledBy;
    }

    public void setSchedulingCanceledBy(UserReference schedulingCanceledBy) {
        this.schedulingCanceledBy = schedulingCanceledBy;
    }

    public BuScheduleRun schedulingCompletedTime(Date schedulingCompletedTime) {
        this.schedulingCompletedTime = schedulingCompletedTime;
        return this;
    }

    @ApiModelProperty(example="null", value="When the scheduling run was completed, if applicable. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="schedulingCompletedTime")
    public Date getSchedulingCompletedTime() {
        return this.schedulingCompletedTime;
    }

    public void setSchedulingCompletedTime(Date schedulingCompletedTime) {
        this.schedulingCompletedTime = schedulingCompletedTime;
    }

    public BuScheduleRun messageCount(Integer messageCount) {
        this.messageCount = messageCount;
        return this;
    }

    @ApiModelProperty(example="null", value="The number of schedule generation messages for this schedule generation run")
    @JsonProperty(value="messageCount")
    public Integer getMessageCount() {
        return this.messageCount;
    }

    public void setMessageCount(Integer messageCount) {
        this.messageCount = messageCount;
    }

    public BuScheduleRun messageSeverityCounts(List<SchedulerMessageSeverityCount> messageSeverityCounts) {
        this.messageSeverityCounts = messageSeverityCounts;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of schedule generation message counts by severity for this schedule generation run")
    @JsonProperty(value="messageSeverityCounts")
    public List<SchedulerMessageSeverityCount> getMessageSeverityCounts() {
        return this.messageSeverityCounts;
    }

    public void setMessageSeverityCounts(List<SchedulerMessageSeverityCount> messageSeverityCounts) {
        this.messageSeverityCounts = messageSeverityCounts;
    }

    public BuScheduleRun reschedulingOptions(ReschedulingOptionsRunResponse reschedulingOptions) {
        this.reschedulingOptions = reschedulingOptions;
        return this;
    }

    @ApiModelProperty(example="null", value="Rescheduling options for this run.  Null unless intradayRescheduling is true")
    @JsonProperty(value="reschedulingOptions")
    public ReschedulingOptionsRunResponse getReschedulingOptions() {
        return this.reschedulingOptions;
    }

    public void setReschedulingOptions(ReschedulingOptionsRunResponse reschedulingOptions) {
        this.reschedulingOptions = reschedulingOptions;
    }

    public BuScheduleRun reschedulingResultExpiration(Date reschedulingResultExpiration) {
        this.reschedulingResultExpiration = reschedulingResultExpiration;
        return this;
    }

    @ApiModelProperty(example="null", value="When the reschedule result will expire.  Null unless intradayRescheduling is true. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="reschedulingResultExpiration")
    public Date getReschedulingResultExpiration() {
        return this.reschedulingResultExpiration;
    }

    public void setReschedulingResultExpiration(Date reschedulingResultExpiration) {
        this.reschedulingResultExpiration = reschedulingResultExpiration;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuScheduleRun buScheduleRun = (BuScheduleRun)o;
        return Objects.equals(this.id, buScheduleRun.id) && Objects.equals(this.schedulerRunId, buScheduleRun.schedulerRunId) && Objects.equals(this.intradayRescheduling, buScheduleRun.intradayRescheduling) && Objects.equals((Object)this.state, (Object)buScheduleRun.state) && Objects.equals(this.weekCount, buScheduleRun.weekCount) && Objects.equals(this.percentComplete, buScheduleRun.percentComplete) && Objects.equals(this.targetWeek, buScheduleRun.targetWeek) && Objects.equals(this.schedule, buScheduleRun.schedule) && Objects.equals(this.scheduleDescription, buScheduleRun.scheduleDescription) && Objects.equals(this.schedulingStartTime, buScheduleRun.schedulingStartTime) && Objects.equals(this.schedulingStartedBy, buScheduleRun.schedulingStartedBy) && Objects.equals(this.schedulingCanceledBy, buScheduleRun.schedulingCanceledBy) && Objects.equals(this.schedulingCompletedTime, buScheduleRun.schedulingCompletedTime) && Objects.equals(this.messageCount, buScheduleRun.messageCount) && Objects.equals(this.messageSeverityCounts, buScheduleRun.messageSeverityCounts) && Objects.equals(this.reschedulingOptions, buScheduleRun.reschedulingOptions) && Objects.equals(this.reschedulingResultExpiration, buScheduleRun.reschedulingResultExpiration) && Objects.equals(this.selfUri, buScheduleRun.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.schedulerRunId, this.intradayRescheduling, this.state, this.weekCount, this.percentComplete, this.targetWeek, this.schedule, this.scheduleDescription, this.schedulingStartTime, this.schedulingStartedBy, this.schedulingCanceledBy, this.schedulingCompletedTime, this.messageCount, this.messageSeverityCounts, this.reschedulingOptions, this.reschedulingResultExpiration, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BuScheduleRun {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    schedulerRunId: ").append(this.toIndentedString(this.schedulerRunId)).append("\n");
        sb.append("    intradayRescheduling: ").append(this.toIndentedString(this.intradayRescheduling)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    weekCount: ").append(this.toIndentedString(this.weekCount)).append("\n");
        sb.append("    percentComplete: ").append(this.toIndentedString(this.percentComplete)).append("\n");
        sb.append("    targetWeek: ").append(this.toIndentedString(this.targetWeek)).append("\n");
        sb.append("    schedule: ").append(this.toIndentedString(this.schedule)).append("\n");
        sb.append("    scheduleDescription: ").append(this.toIndentedString(this.scheduleDescription)).append("\n");
        sb.append("    schedulingStartTime: ").append(this.toIndentedString(this.schedulingStartTime)).append("\n");
        sb.append("    schedulingStartedBy: ").append(this.toIndentedString(this.schedulingStartedBy)).append("\n");
        sb.append("    schedulingCanceledBy: ").append(this.toIndentedString(this.schedulingCanceledBy)).append("\n");
        sb.append("    schedulingCompletedTime: ").append(this.toIndentedString(this.schedulingCompletedTime)).append("\n");
        sb.append("    messageCount: ").append(this.toIndentedString(this.messageCount)).append("\n");
        sb.append("    messageSeverityCounts: ").append(this.toIndentedString(this.messageSeverityCounts)).append("\n");
        sb.append("    reschedulingOptions: ").append(this.toIndentedString(this.reschedulingOptions)).append("\n");
        sb.append("    reschedulingResultExpiration: ").append(this.toIndentedString(this.reschedulingResultExpiration)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StateEnumDeserializer.class)
    public static enum StateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        NONE("None"),
        QUEUED("Queued"),
        SCHEDULING("Scheduling"),
        CANCELED("Canceled"),
        FAILED("Failed"),
        COMPLETE("Complete");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateEnum value : StateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StateEnumDeserializer
    extends StdDeserializer<StateEnum> {
        public StateEnumDeserializer() {
            super(StateEnumDeserializer.class);
        }

        public StateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StateEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

