/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.BuIntradayDataGroup;
import com.mypurecloud.sdk.v2.model.BuScheduleReference;
import com.mypurecloud.sdk.v2.model.BuShortTermForecastReference;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class BuIntradayResponse
implements Serializable {
    private Date startDate = null;
    private Date endDate = null;
    private Integer intervalLengthMinutes = null;
    private NoDataReasonEnum noDataReason = null;
    private List<CategoriesEnum> categories = null;
    private BuShortTermForecastReference shortTermForecast = null;
    private BuScheduleReference schedule = null;
    private List<BuIntradayDataGroup> intradayDataGroupings = null;

    public BuIntradayResponse startDate(Date startDate) {
        this.startDate = startDate;
        return this;
    }

    @ApiModelProperty(example="null", value="The start of the date range for which this data applies.  This is also the start reference point for the intervals represented in the various arrays. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="startDate")
    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public BuIntradayResponse endDate(Date endDate) {
        this.endDate = endDate;
        return this;
    }

    @ApiModelProperty(example="null", value="The end of the date range for which this data applies. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="endDate")
    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public BuIntradayResponse intervalLengthMinutes(Integer intervalLengthMinutes) {
        this.intervalLengthMinutes = intervalLengthMinutes;
        return this;
    }

    @ApiModelProperty(example="null", value="The aggregation period in minutes, which determines the interval duration of the returned data")
    @JsonProperty(value="intervalLengthMinutes")
    public Integer getIntervalLengthMinutes() {
        return this.intervalLengthMinutes;
    }

    public void setIntervalLengthMinutes(Integer intervalLengthMinutes) {
        this.intervalLengthMinutes = intervalLengthMinutes;
    }

    public BuIntradayResponse noDataReason(NoDataReasonEnum noDataReason) {
        this.noDataReason = noDataReason;
        return this;
    }

    @ApiModelProperty(example="null", value="If not null, the reason there was no data for the request")
    @JsonProperty(value="noDataReason")
    public NoDataReasonEnum getNoDataReason() {
        return this.noDataReason;
    }

    public void setNoDataReason(NoDataReasonEnum noDataReason) {
        this.noDataReason = noDataReason;
    }

    public BuIntradayResponse categories(List<CategoriesEnum> categories) {
        this.categories = categories;
        return this;
    }

    @ApiModelProperty(example="null", value="The categories to which this data corresponds")
    @JsonProperty(value="categories")
    public List<CategoriesEnum> getCategories() {
        return this.categories;
    }

    public void setCategories(List<CategoriesEnum> categories) {
        this.categories = categories;
    }

    public BuIntradayResponse shortTermForecast(BuShortTermForecastReference shortTermForecast) {
        this.shortTermForecast = shortTermForecast;
        return this;
    }

    @ApiModelProperty(example="null", value="Short term forecast reference")
    @JsonProperty(value="shortTermForecast")
    public BuShortTermForecastReference getShortTermForecast() {
        return this.shortTermForecast;
    }

    public void setShortTermForecast(BuShortTermForecastReference shortTermForecast) {
        this.shortTermForecast = shortTermForecast;
    }

    public BuIntradayResponse schedule(BuScheduleReference schedule) {
        this.schedule = schedule;
        return this;
    }

    @ApiModelProperty(example="null", value="Schedule reference")
    @JsonProperty(value="schedule")
    public BuScheduleReference getSchedule() {
        return this.schedule;
    }

    public void setSchedule(BuScheduleReference schedule) {
        this.schedule = schedule;
    }

    public BuIntradayResponse intradayDataGroupings(List<BuIntradayDataGroup> intradayDataGroupings) {
        this.intradayDataGroupings = intradayDataGroupings;
        return this;
    }

    @ApiModelProperty(example="null", value="Intraday data grouped by a single media type and set of planning group IDs")
    @JsonProperty(value="intradayDataGroupings")
    public List<BuIntradayDataGroup> getIntradayDataGroupings() {
        return this.intradayDataGroupings;
    }

    public void setIntradayDataGroupings(List<BuIntradayDataGroup> intradayDataGroupings) {
        this.intradayDataGroupings = intradayDataGroupings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuIntradayResponse buIntradayResponse = (BuIntradayResponse)o;
        return Objects.equals(this.startDate, buIntradayResponse.startDate) && Objects.equals(this.endDate, buIntradayResponse.endDate) && Objects.equals(this.intervalLengthMinutes, buIntradayResponse.intervalLengthMinutes) && Objects.equals((Object)this.noDataReason, (Object)buIntradayResponse.noDataReason) && Objects.equals(this.categories, buIntradayResponse.categories) && Objects.equals(this.shortTermForecast, buIntradayResponse.shortTermForecast) && Objects.equals(this.schedule, buIntradayResponse.schedule) && Objects.equals(this.intradayDataGroupings, buIntradayResponse.intradayDataGroupings);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.startDate, this.endDate, this.intervalLengthMinutes, this.noDataReason, this.categories, this.shortTermForecast, this.schedule, this.intradayDataGroupings});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BuIntradayResponse {\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    intervalLengthMinutes: ").append(this.toIndentedString(this.intervalLengthMinutes)).append("\n");
        sb.append("    noDataReason: ").append(this.toIndentedString((Object)this.noDataReason)).append("\n");
        sb.append("    categories: ").append(this.toIndentedString(this.categories)).append("\n");
        sb.append("    shortTermForecast: ").append(this.toIndentedString(this.shortTermForecast)).append("\n");
        sb.append("    schedule: ").append(this.toIndentedString(this.schedule)).append("\n");
        sb.append("    intradayDataGroupings: ").append(this.toIndentedString(this.intradayDataGroupings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=CategoriesEnumDeserializer.class)
    public static enum CategoriesEnum {
        FORECASTDATA("ForecastData"),
        SCHEDULEDATA("ScheduleData"),
        PERFORMANCEPREDICTIONDATA("PerformancePredictionData");

        private String value;

        private CategoriesEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static CategoriesEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (CategoriesEnum value : CategoriesEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return CategoriesEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class CategoriesEnumDeserializer
    extends StdDeserializer<CategoriesEnum> {
        public CategoriesEnumDeserializer() {
            super(CategoriesEnumDeserializer.class);
        }

        public CategoriesEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return CategoriesEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=NoDataReasonEnumDeserializer.class)
    public static enum NoDataReasonEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        NOPUBLISHEDSCHEDULE("NoPublishedSchedule"),
        NOSOURCEFORECAST("NoSourceForecast");

        private String value;

        private NoDataReasonEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static NoDataReasonEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (NoDataReasonEnum value : NoDataReasonEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return NoDataReasonEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class NoDataReasonEnumDeserializer
    extends StdDeserializer<NoDataReasonEnum> {
        public NoDataReasonEnumDeserializer() {
            super(NoDataReasonEnumDeserializer.class);
        }

        public NoDataReasonEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return NoDataReasonEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

