/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.AuditEntity;
import com.mypurecloud.sdk.v2.model.AuditUser;
import com.mypurecloud.sdk.v2.model.Change;
import com.mypurecloud.sdk.v2.model.ServiceContext;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;

public class AuditMessage
implements Serializable {
    private String id = null;
    private AuditUser user = null;
    private String correlationId = null;
    private String transactionId = null;
    private Boolean transactionInitiator = null;
    private String application = null;
    private String serviceName = null;
    private String level = null;
    private String timestamp = null;
    private String receivedTimestamp = null;
    private String status = null;
    private String actionContext = null;
    private String action = null;
    private List<Change> changes = null;
    private AuditEntity entity = null;
    private ServiceContext serviceContext = null;

    public AuditMessage id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="AuditMessage ID.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public AuditMessage user(AuditUser user) {
        this.user = user;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="user")
    public AuditUser getUser() {
        return this.user;
    }

    public void setUser(AuditUser user) {
        this.user = user;
    }

    public AuditMessage correlationId(String correlationId) {
        this.correlationId = correlationId;
        return this;
    }

    @ApiModelProperty(example="null", value="Correlation ID.")
    @JsonProperty(value="correlationId")
    public String getCorrelationId() {
        return this.correlationId;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public AuditMessage transactionId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    @ApiModelProperty(example="null", value="Transaction ID.")
    @JsonProperty(value="transactionId")
    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public AuditMessage transactionInitiator(Boolean transactionInitiator) {
        this.transactionInitiator = transactionInitiator;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether or not this audit can be considered the initiator of the transaction it is a part of.")
    @JsonProperty(value="transactionInitiator")
    public Boolean getTransactionInitiator() {
        return this.transactionInitiator;
    }

    public void setTransactionInitiator(Boolean transactionInitiator) {
        this.transactionInitiator = transactionInitiator;
    }

    public AuditMessage application(String application) {
        this.application = application;
        return this;
    }

    @ApiModelProperty(example="null", value="The application through which the action of this AuditMessage was initiated.")
    @JsonProperty(value="application")
    public String getApplication() {
        return this.application;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public AuditMessage serviceName(String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of the service which sent this AuditMessage.")
    @JsonProperty(value="serviceName")
    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public AuditMessage level(String level) {
        this.level = level;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The level of this audit. USER or SYSTEM.")
    @JsonProperty(value="level")
    public String getLevel() {
        return this.level;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public AuditMessage timestamp(String timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @ApiModelProperty(example="null", value="The time at which the action of this AuditMessage was initiated.")
    @JsonProperty(value="timestamp")
    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public AuditMessage receivedTimestamp(String receivedTimestamp) {
        this.receivedTimestamp = receivedTimestamp;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The time at which this AuditMessage was received.")
    @JsonProperty(value="receivedTimestamp")
    public String getReceivedTimestamp() {
        return this.receivedTimestamp;
    }

    public void setReceivedTimestamp(String receivedTimestamp) {
        this.receivedTimestamp = receivedTimestamp;
    }

    public AuditMessage status(String status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The status of the action of this AuditMessage")
    @JsonProperty(value="status")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public AuditMessage actionContext(String actionContext) {
        this.actionContext = actionContext;
        return this;
    }

    @ApiModelProperty(example="null", value="The context of a system-level action")
    @JsonProperty(value="actionContext")
    public String getActionContext() {
        return this.actionContext;
    }

    public void setActionContext(String actionContext) {
        this.actionContext = actionContext;
    }

    public AuditMessage action(String action) {
        this.action = action;
        return this;
    }

    @ApiModelProperty(example="null", value="A string representing the action that took place")
    @JsonProperty(value="action")
    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public AuditMessage changes(List<Change> changes) {
        this.changes = changes;
        return this;
    }

    @ApiModelProperty(example="null", value="Details about any changes that occurred in this audit")
    @JsonProperty(value="changes")
    public List<Change> getChanges() {
        return this.changes;
    }

    public void setChanges(List<Change> changes) {
        this.changes = changes;
    }

    public AuditMessage entity(AuditEntity entity) {
        this.entity = entity;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="entity")
    public AuditEntity getEntity() {
        return this.entity;
    }

    public void setEntity(AuditEntity entity) {
        this.entity = entity;
    }

    public AuditMessage serviceContext(ServiceContext serviceContext) {
        this.serviceContext = serviceContext;
        return this;
    }

    @ApiModelProperty(example="null", value="The service-specific context associated with this AuditMessage.")
    @JsonProperty(value="serviceContext")
    public ServiceContext getServiceContext() {
        return this.serviceContext;
    }

    public void setServiceContext(ServiceContext serviceContext) {
        this.serviceContext = serviceContext;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuditMessage auditMessage = (AuditMessage)o;
        return Objects.equals(this.id, auditMessage.id) && Objects.equals(this.user, auditMessage.user) && Objects.equals(this.correlationId, auditMessage.correlationId) && Objects.equals(this.transactionId, auditMessage.transactionId) && Objects.equals(this.transactionInitiator, auditMessage.transactionInitiator) && Objects.equals(this.application, auditMessage.application) && Objects.equals(this.serviceName, auditMessage.serviceName) && Objects.equals(this.level, auditMessage.level) && Objects.equals(this.timestamp, auditMessage.timestamp) && Objects.equals(this.receivedTimestamp, auditMessage.receivedTimestamp) && Objects.equals(this.status, auditMessage.status) && Objects.equals(this.actionContext, auditMessage.actionContext) && Objects.equals(this.action, auditMessage.action) && Objects.equals(this.changes, auditMessage.changes) && Objects.equals(this.entity, auditMessage.entity) && Objects.equals(this.serviceContext, auditMessage.serviceContext);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.user, this.correlationId, this.transactionId, this.transactionInitiator, this.application, this.serviceName, this.level, this.timestamp, this.receivedTimestamp, this.status, this.actionContext, this.action, this.changes, this.entity, this.serviceContext);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuditMessage {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    correlationId: ").append(this.toIndentedString(this.correlationId)).append("\n");
        sb.append("    transactionId: ").append(this.toIndentedString(this.transactionId)).append("\n");
        sb.append("    transactionInitiator: ").append(this.toIndentedString(this.transactionInitiator)).append("\n");
        sb.append("    application: ").append(this.toIndentedString(this.application)).append("\n");
        sb.append("    serviceName: ").append(this.toIndentedString(this.serviceName)).append("\n");
        sb.append("    level: ").append(this.toIndentedString(this.level)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("    receivedTimestamp: ").append(this.toIndentedString(this.receivedTimestamp)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    actionContext: ").append(this.toIndentedString(this.actionContext)).append("\n");
        sb.append("    action: ").append(this.toIndentedString(this.action)).append("\n");
        sb.append("    changes: ").append(this.toIndentedString(this.changes)).append("\n");
        sb.append("    entity: ").append(this.toIndentedString(this.entity)).append("\n");
        sb.append("    serviceContext: ").append(this.toIndentedString(this.serviceContext)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

