/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.ArchitectFlowOutcomeNotificationClient;
import com.mypurecloud.sdk.v2.model.ArchitectFlowOutcomeNotificationErrorDetail;
import com.mypurecloud.sdk.v2.model.ArchitectFlowOutcomeNotificationUser;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Describes an operation being performed on an Architect object")
public class ArchitectFlowOutcomeNotificationArchitectOperation
implements Serializable {
    private String id = null;
    private Boolean complete = null;
    private ArchitectFlowOutcomeNotificationUser user = null;
    private ArchitectFlowOutcomeNotificationClient client = null;
    private ActionNameEnum actionName = null;
    private ActionStatusEnum actionStatus = null;
    private String errorMessage = null;
    private String errorCode = null;
    private Object errorMessageParams = null;
    private List<ArchitectFlowOutcomeNotificationErrorDetail> errorDetails = null;

    public ArchitectFlowOutcomeNotificationArchitectOperation id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="A unique identifier for this operation, as generated by the initiating client")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ArchitectFlowOutcomeNotificationArchitectOperation complete(Boolean complete) {
        this.complete = complete;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates if the operation is complete")
    @JsonProperty(value="complete")
    public Boolean getComplete() {
        return this.complete;
    }

    public void setComplete(Boolean complete) {
        this.complete = complete;
    }

    public ArchitectFlowOutcomeNotificationArchitectOperation user(ArchitectFlowOutcomeNotificationUser user) {
        this.user = user;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="user")
    public ArchitectFlowOutcomeNotificationUser getUser() {
        return this.user;
    }

    public void setUser(ArchitectFlowOutcomeNotificationUser user) {
        this.user = user;
    }

    public ArchitectFlowOutcomeNotificationArchitectOperation client(ArchitectFlowOutcomeNotificationClient client) {
        this.client = client;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="client")
    public ArchitectFlowOutcomeNotificationClient getClient() {
        return this.client;
    }

    public void setClient(ArchitectFlowOutcomeNotificationClient client) {
        this.client = client;
    }

    public ArchitectFlowOutcomeNotificationArchitectOperation actionName(ActionNameEnum actionName) {
        this.actionName = actionName;
        return this;
    }

    @ApiModelProperty(example="null", value="The action being performed")
    @JsonProperty(value="actionName")
    public ActionNameEnum getActionName() {
        return this.actionName;
    }

    public void setActionName(ActionNameEnum actionName) {
        this.actionName = actionName;
    }

    public ArchitectFlowOutcomeNotificationArchitectOperation actionStatus(ActionStatusEnum actionStatus) {
        this.actionStatus = actionStatus;
        return this;
    }

    @ApiModelProperty(example="null", value="The action status")
    @JsonProperty(value="actionStatus")
    public ActionStatusEnum getActionStatus() {
        return this.actionStatus;
    }

    public void setActionStatus(ActionStatusEnum actionStatus) {
        this.actionStatus = actionStatus;
    }

    public ArchitectFlowOutcomeNotificationArchitectOperation errorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    @ApiModelProperty(example="null", value="The error message, if the action failed")
    @JsonProperty(value="errorMessage")
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public ArchitectFlowOutcomeNotificationArchitectOperation errorCode(String errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    @ApiModelProperty(example="null", value="The error code, if the action failed")
    @JsonProperty(value="errorCode")
    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public ArchitectFlowOutcomeNotificationArchitectOperation errorMessageParams(Object errorMessageParams) {
        this.errorMessageParams = errorMessageParams;
        return this;
    }

    @ApiModelProperty(example="null", value="The error message params, if the action failed")
    @JsonProperty(value="errorMessageParams")
    public Object getErrorMessageParams() {
        return this.errorMessageParams;
    }

    public void setErrorMessageParams(Object errorMessageParams) {
        this.errorMessageParams = errorMessageParams;
    }

    public ArchitectFlowOutcomeNotificationArchitectOperation errorDetails(List<ArchitectFlowOutcomeNotificationErrorDetail> errorDetails) {
        this.errorDetails = errorDetails;
        return this;
    }

    @ApiModelProperty(example="null", value="The error details, if the action failed")
    @JsonProperty(value="errorDetails")
    public List<ArchitectFlowOutcomeNotificationErrorDetail> getErrorDetails() {
        return this.errorDetails;
    }

    public void setErrorDetails(List<ArchitectFlowOutcomeNotificationErrorDetail> errorDetails) {
        this.errorDetails = errorDetails;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArchitectFlowOutcomeNotificationArchitectOperation architectFlowOutcomeNotificationArchitectOperation = (ArchitectFlowOutcomeNotificationArchitectOperation)o;
        return Objects.equals(this.id, architectFlowOutcomeNotificationArchitectOperation.id) && Objects.equals(this.complete, architectFlowOutcomeNotificationArchitectOperation.complete) && Objects.equals(this.user, architectFlowOutcomeNotificationArchitectOperation.user) && Objects.equals(this.client, architectFlowOutcomeNotificationArchitectOperation.client) && Objects.equals((Object)this.actionName, (Object)architectFlowOutcomeNotificationArchitectOperation.actionName) && Objects.equals((Object)this.actionStatus, (Object)architectFlowOutcomeNotificationArchitectOperation.actionStatus) && Objects.equals(this.errorMessage, architectFlowOutcomeNotificationArchitectOperation.errorMessage) && Objects.equals(this.errorCode, architectFlowOutcomeNotificationArchitectOperation.errorCode) && Objects.equals(this.errorMessageParams, architectFlowOutcomeNotificationArchitectOperation.errorMessageParams) && Objects.equals(this.errorDetails, architectFlowOutcomeNotificationArchitectOperation.errorDetails);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.complete, this.user, this.client, this.actionName, this.actionStatus, this.errorMessage, this.errorCode, this.errorMessageParams, this.errorDetails});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ArchitectFlowOutcomeNotificationArchitectOperation {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    complete: ").append(this.toIndentedString(this.complete)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    client: ").append(this.toIndentedString(this.client)).append("\n");
        sb.append("    actionName: ").append(this.toIndentedString((Object)this.actionName)).append("\n");
        sb.append("    actionStatus: ").append(this.toIndentedString((Object)this.actionStatus)).append("\n");
        sb.append("    errorMessage: ").append(this.toIndentedString(this.errorMessage)).append("\n");
        sb.append("    errorCode: ").append(this.toIndentedString(this.errorCode)).append("\n");
        sb.append("    errorMessageParams: ").append(this.toIndentedString(this.errorMessageParams)).append("\n");
        sb.append("    errorDetails: ").append(this.toIndentedString(this.errorDetails)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ActionStatusEnumDeserializer.class)
    public static enum ActionStatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        LOCKED("LOCKED"),
        UNLOCKED("UNLOCKED"),
        STARTED("STARTED"),
        PENDING_GENERATION("PENDING_GENERATION"),
        PENDING_BACKEND_NOTIFICATION("PENDING_BACKEND_NOTIFICATION"),
        SUCCESS("SUCCESS"),
        FAILURE("FAILURE");

        private String value;

        private ActionStatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ActionStatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ActionStatusEnum value : ActionStatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ActionStatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ActionStatusEnumDeserializer
    extends StdDeserializer<ActionStatusEnum> {
        public ActionStatusEnumDeserializer() {
            super(ActionStatusEnumDeserializer.class);
        }

        public ActionStatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ActionStatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=ActionNameEnumDeserializer.class)
    public static enum ActionNameEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CREATE("CREATE"),
        CHECKIN("CHECKIN"),
        DEBUG("DEBUG"),
        DELETE("DELETE"),
        HISTORY("HISTORY"),
        PUBLISH("PUBLISH"),
        STATE_CHANGE("STATE_CHANGE"),
        UPDATE("UPDATE"),
        VALIDATE("VALIDATE");

        private String value;

        private ActionNameEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ActionNameEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ActionNameEnum value : ActionNameEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ActionNameEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ActionNameEnumDeserializer
    extends StdDeserializer<ActionNameEnum> {
        public ActionNameEnumDeserializer() {
            super(ActionNameEnumDeserializer.class);
        }

        public ActionNameEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ActionNameEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

