/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PutUserRolesRequest {
    private String subjectId;
    private List<String> body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getSubjectId() {
        return this.subjectId;
    }

    public void setSubjectId(String subjectId) {
        this.subjectId = subjectId;
    }

    public PutUserRolesRequest withSubjectId(String subjectId) {
        this.setSubjectId(subjectId);
        return this;
    }

    public List<String> getBody() {
        return this.body;
    }

    public void setBody(List<String> body) {
        this.body = body;
    }

    public PutUserRolesRequest withBody(List<String> body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PutUserRolesRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<List<String>> withHttpInfo() {
        if (this.subjectId == null) {
            throw new IllegalStateException("Missing the required parameter 'subjectId' when building request for PutUserRolesRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PutUserRolesRequest.");
        }
        return ApiRequestBuilder.create("PUT", "/api/v2/users/{subjectId}/roles").withPathParameter("subjectId", this.subjectId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String subjectId, List<String> body) {
        return new Builder().withRequiredParams(subjectId, body);
    }

    public static class Builder {
        private final PutUserRolesRequest request = new PutUserRolesRequest();

        private Builder() {
        }

        public Builder withSubjectId(String subjectId) {
            this.request.setSubjectId(subjectId);
            return this;
        }

        public Builder withBody(List<String> body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String subjectId, List<String> body) {
            this.request.setSubjectId(subjectId);
            this.request.setBody(body);
            return this;
        }

        public PutUserRolesRequest build() {
            if (this.request.subjectId == null) {
                throw new IllegalStateException("Missing the required parameter 'subjectId' when building request for PutUserRolesRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PutUserRolesRequest.");
            }
            return this.request;
        }
    }
}

