/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class GetRoutingPredictorModelFeaturesRequest {
    private String predictorId;
    private String modelId;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getPredictorId() {
        return this.predictorId;
    }

    public void setPredictorId(String predictorId) {
        this.predictorId = predictorId;
    }

    public GetRoutingPredictorModelFeaturesRequest withPredictorId(String predictorId) {
        this.setPredictorId(predictorId);
        return this;
    }

    public String getModelId() {
        return this.modelId;
    }

    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    public GetRoutingPredictorModelFeaturesRequest withModelId(String modelId) {
        this.setModelId(modelId);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetRoutingPredictorModelFeaturesRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.predictorId == null) {
            throw new IllegalStateException("Missing the required parameter 'predictorId' when building request for GetRoutingPredictorModelFeaturesRequest.");
        }
        if (this.modelId == null) {
            throw new IllegalStateException("Missing the required parameter 'modelId' when building request for GetRoutingPredictorModelFeaturesRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/routing/predictors/{predictorId}/models/{modelId}/features").withPathParameter("predictorId", this.predictorId).withPathParameter("modelId", this.modelId).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String predictorId, String modelId) {
        return new Builder().withRequiredParams(predictorId, modelId);
    }

    public static class Builder {
        private final GetRoutingPredictorModelFeaturesRequest request = new GetRoutingPredictorModelFeaturesRequest();

        private Builder() {
        }

        public Builder withPredictorId(String predictorId) {
            this.request.setPredictorId(predictorId);
            return this;
        }

        public Builder withModelId(String modelId) {
            this.request.setModelId(modelId);
            return this;
        }

        public Builder withRequiredParams(String predictorId, String modelId) {
            this.request.setPredictorId(predictorId);
            this.request.setModelId(modelId);
            return this;
        }

        public GetRoutingPredictorModelFeaturesRequest build() {
            if (this.request.predictorId == null) {
                throw new IllegalStateException("Missing the required parameter 'predictorId' when building request for GetRoutingPredictorModelFeaturesRequest.");
            }
            if (this.request.modelId == null) {
                throw new IllegalStateException("Missing the required parameter 'modelId' when building request for GetRoutingPredictorModelFeaturesRequest.");
            }
            return this.request;
        }
    }
}

