/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.AssessmentForm;
import com.mypurecloud.sdk.v2.model.LearningModuleCoverArtResponse;
import com.mypurecloud.sdk.v2.model.LearningModuleInformStep;
import com.mypurecloud.sdk.v2.model.LearningModuleRule;
import com.mypurecloud.sdk.v2.model.LearningModuleSummary;
import com.mypurecloud.sdk.v2.model.UserReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Learning module response")
public class LearningModule
implements Serializable {
    private String id = null;
    private String name = null;
    private UserReference createdBy = null;
    private Date dateCreated = null;
    private UserReference modifiedBy = null;
    private Date dateModified = null;
    private Integer version = null;
    private String externalId = null;
    private SourceEnum source = null;
    private LearningModuleRule rule = null;
    private String selfUri = null;
    private Boolean isArchived = null;
    private Boolean isPublished = null;
    private String description = null;
    private Integer completionTimeInDays = null;
    private TypeEnum type = null;
    private List<LearningModuleInformStep> informSteps = new ArrayList<LearningModuleInformStep>();
    private AssessmentForm assessmentForm = null;
    private LearningModuleSummary summaryData = null;
    private LearningModuleCoverArtResponse coverArt = null;
    private ArchivalModeEnum archivalMode = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public LearningModule name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of learning module")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(example="null", value="The user who created learning module")
    @JsonProperty(value="createdBy")
    public UserReference getCreatedBy() {
        return this.createdBy;
    }

    @ApiModelProperty(example="null", value="The date/time learning module was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    @ApiModelProperty(example="null", value="The user who modified learning module")
    @JsonProperty(value="modifiedBy")
    public UserReference getModifiedBy() {
        return this.modifiedBy;
    }

    @ApiModelProperty(example="null", value="The date/time learning module was modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    @ApiModelProperty(example="null", value="The version of published learning module")
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    @ApiModelProperty(example="null", value="The external ID of the learning module")
    @JsonProperty(value="externalId")
    public String getExternalId() {
        return this.externalId;
    }

    @ApiModelProperty(example="null", value="The source of the learning module")
    @JsonProperty(value="source")
    public SourceEnum getSource() {
        return this.source;
    }

    @ApiModelProperty(example="null", value="The rule for learning module; read-only, and only populated when requested via expand param.")
    @JsonProperty(value="rule")
    public LearningModuleRule getRule() {
        return this.rule;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    @ApiModelProperty(example="null", value="If true, learning module is archived")
    @JsonProperty(value="isArchived")
    public Boolean getIsArchived() {
        return this.isArchived;
    }

    @ApiModelProperty(example="null", value="If true, learning module is published")
    @JsonProperty(value="isPublished")
    public Boolean getIsPublished() {
        return this.isPublished;
    }

    public LearningModule description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="The description of learning module")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public LearningModule completionTimeInDays(Integer completionTimeInDays) {
        this.completionTimeInDays = completionTimeInDays;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The completion time of learning module in days")
    @JsonProperty(value="completionTimeInDays")
    public Integer getCompletionTimeInDays() {
        return this.completionTimeInDays;
    }

    public void setCompletionTimeInDays(Integer completionTimeInDays) {
        this.completionTimeInDays = completionTimeInDays;
    }

    public LearningModule type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", value="The type for the learning module")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public LearningModule informSteps(List<LearningModuleInformStep> informSteps) {
        this.informSteps = informSteps;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of inform steps in a learning module")
    @JsonProperty(value="informSteps")
    public List<LearningModuleInformStep> getInformSteps() {
        return this.informSteps;
    }

    public void setInformSteps(List<LearningModuleInformStep> informSteps) {
        this.informSteps = informSteps;
    }

    public LearningModule assessmentForm(AssessmentForm assessmentForm) {
        this.assessmentForm = assessmentForm;
        return this;
    }

    @ApiModelProperty(example="null", value="The assessment form for learning module")
    @JsonProperty(value="assessmentForm")
    public AssessmentForm getAssessmentForm() {
        return this.assessmentForm;
    }

    public void setAssessmentForm(AssessmentForm assessmentForm) {
        this.assessmentForm = assessmentForm;
    }

    public LearningModule summaryData(LearningModuleSummary summaryData) {
        this.summaryData = summaryData;
        return this;
    }

    @ApiModelProperty(example="null", value="The learning module summary data")
    @JsonProperty(value="summaryData")
    public LearningModuleSummary getSummaryData() {
        return this.summaryData;
    }

    public void setSummaryData(LearningModuleSummary summaryData) {
        this.summaryData = summaryData;
    }

    public LearningModule coverArt(LearningModuleCoverArtResponse coverArt) {
        this.coverArt = coverArt;
        return this;
    }

    @ApiModelProperty(example="null", value="The cover art for the learning module")
    @JsonProperty(value="coverArt")
    public LearningModuleCoverArtResponse getCoverArt() {
        return this.coverArt;
    }

    public void setCoverArt(LearningModuleCoverArtResponse coverArt) {
        this.coverArt = coverArt;
    }

    public LearningModule archivalMode(ArchivalModeEnum archivalMode) {
        this.archivalMode = archivalMode;
        return this;
    }

    @ApiModelProperty(example="null", value="The mode of archival for learning module")
    @JsonProperty(value="archivalMode")
    public ArchivalModeEnum getArchivalMode() {
        return this.archivalMode;
    }

    public void setArchivalMode(ArchivalModeEnum archivalMode) {
        this.archivalMode = archivalMode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LearningModule learningModule = (LearningModule)o;
        return Objects.equals(this.id, learningModule.id) && Objects.equals(this.name, learningModule.name) && Objects.equals(this.createdBy, learningModule.createdBy) && Objects.equals(this.dateCreated, learningModule.dateCreated) && Objects.equals(this.modifiedBy, learningModule.modifiedBy) && Objects.equals(this.dateModified, learningModule.dateModified) && Objects.equals(this.version, learningModule.version) && Objects.equals(this.externalId, learningModule.externalId) && Objects.equals((Object)this.source, (Object)learningModule.source) && Objects.equals(this.rule, learningModule.rule) && Objects.equals(this.selfUri, learningModule.selfUri) && Objects.equals(this.isArchived, learningModule.isArchived) && Objects.equals(this.isPublished, learningModule.isPublished) && Objects.equals(this.description, learningModule.description) && Objects.equals(this.completionTimeInDays, learningModule.completionTimeInDays) && Objects.equals((Object)this.type, (Object)learningModule.type) && Objects.equals(this.informSteps, learningModule.informSteps) && Objects.equals(this.assessmentForm, learningModule.assessmentForm) && Objects.equals(this.summaryData, learningModule.summaryData) && Objects.equals(this.coverArt, learningModule.coverArt) && Objects.equals((Object)this.archivalMode, (Object)learningModule.archivalMode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.createdBy, this.dateCreated, this.modifiedBy, this.dateModified, this.version, this.externalId, this.source, this.rule, this.selfUri, this.isArchived, this.isPublished, this.description, this.completionTimeInDays, this.type, this.informSteps, this.assessmentForm, this.summaryData, this.coverArt, this.archivalMode});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LearningModule {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    modifiedBy: ").append(this.toIndentedString(this.modifiedBy)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    externalId: ").append(this.toIndentedString(this.externalId)).append("\n");
        sb.append("    source: ").append(this.toIndentedString((Object)this.source)).append("\n");
        sb.append("    rule: ").append(this.toIndentedString(this.rule)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("    isArchived: ").append(this.toIndentedString(this.isArchived)).append("\n");
        sb.append("    isPublished: ").append(this.toIndentedString(this.isPublished)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    completionTimeInDays: ").append(this.toIndentedString(this.completionTimeInDays)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    informSteps: ").append(this.toIndentedString(this.informSteps)).append("\n");
        sb.append("    assessmentForm: ").append(this.toIndentedString(this.assessmentForm)).append("\n");
        sb.append("    summaryData: ").append(this.toIndentedString(this.summaryData)).append("\n");
        sb.append("    coverArt: ").append(this.toIndentedString(this.coverArt)).append("\n");
        sb.append("    archivalMode: ").append(this.toIndentedString((Object)this.archivalMode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ArchivalModeEnumDeserializer.class)
    public static enum ArchivalModeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        GRACEFUL("Graceful"),
        IMMEDIATE("Immediate");

        private String value;

        private ArchivalModeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ArchivalModeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ArchivalModeEnum value : ArchivalModeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ArchivalModeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ArchivalModeEnumDeserializer
    extends StdDeserializer<ArchivalModeEnum> {
        public ArchivalModeEnumDeserializer() {
            super(ArchivalModeEnumDeserializer.class);
        }

        public ArchivalModeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ArchivalModeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=TypeEnumDeserializer.class)
    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        INFORMATIONAL("Informational"),
        ASSESSEDCONTENT("AssessedContent"),
        ASSESSMENT("Assessment");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class TypeEnumDeserializer
    extends StdDeserializer<TypeEnum> {
        public TypeEnumDeserializer() {
            super(TypeEnumDeserializer.class);
        }

        public TypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=SourceEnumDeserializer.class)
    public static enum SourceEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        USERCREATED("UserCreated"),
        GENESYSBEYOND("GenesysBeyond");

        private String value;

        private SourceEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static SourceEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (SourceEnum value : SourceEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return SourceEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class SourceEnumDeserializer
    extends StdDeserializer<SourceEnum> {
        public SourceEnumDeserializer() {
            super(SourceEnumDeserializer.class);
        }

        public SourceEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return SourceEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

