/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.ContactSort;
import com.mypurecloud.sdk.v2.model.DomainEntityRef;
import com.mypurecloud.sdk.v2.model.RestErrorDetail;
import com.mypurecloud.sdk.v2.model.SmsConfig;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class MessagingCampaign
implements Serializable {
    private String id = null;
    private String name = null;
    private Date dateCreated = null;
    private Date dateModified = null;
    private Integer version = null;
    private DomainEntityRef division = null;
    private CampaignStatusEnum campaignStatus = null;
    private DomainEntityRef callableTimeSet = null;
    private DomainEntityRef contactList = null;
    private List<DomainEntityRef> dncLists = new ArrayList<DomainEntityRef>();
    private Boolean alwaysRunning = null;
    private List<ContactSort> contactSorts = new ArrayList<ContactSort>();
    private Integer messagesPerMinute = null;
    private List<DomainEntityRef> contactListFilters = new ArrayList<DomainEntityRef>();
    private List<RestErrorDetail> errors = new ArrayList<RestErrorDetail>();
    private SmsConfig smsConfig = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public MessagingCampaign name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(example="null", value="Creation time of the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    @ApiModelProperty(example="null", value="Last modified time of the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    public MessagingCampaign version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(example="null", value="Required for updates, must match the version number of the most recent update")
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public MessagingCampaign division(DomainEntityRef division) {
        this.division = division;
        return this;
    }

    @ApiModelProperty(example="null", value="The division this entity belongs to.")
    @JsonProperty(value="division")
    public DomainEntityRef getDivision() {
        return this.division;
    }

    public void setDivision(DomainEntityRef division) {
        this.division = division;
    }

    public MessagingCampaign campaignStatus(CampaignStatusEnum campaignStatus) {
        this.campaignStatus = campaignStatus;
        return this;
    }

    @ApiModelProperty(example="null", value="The current status of the messaging campaign. A messaging campaign may be turned 'on' or 'off'.")
    @JsonProperty(value="campaignStatus")
    public CampaignStatusEnum getCampaignStatus() {
        return this.campaignStatus;
    }

    public void setCampaignStatus(CampaignStatusEnum campaignStatus) {
        this.campaignStatus = campaignStatus;
    }

    public MessagingCampaign callableTimeSet(DomainEntityRef callableTimeSet) {
        this.callableTimeSet = callableTimeSet;
        return this;
    }

    @ApiModelProperty(example="null", value="The callable time set for this messaging campaign.")
    @JsonProperty(value="callableTimeSet")
    public DomainEntityRef getCallableTimeSet() {
        return this.callableTimeSet;
    }

    public void setCallableTimeSet(DomainEntityRef callableTimeSet) {
        this.callableTimeSet = callableTimeSet;
    }

    public MessagingCampaign contactList(DomainEntityRef contactList) {
        this.contactList = contactList;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The contact list that this messaging campaign will send messages for.")
    @JsonProperty(value="contactList")
    public DomainEntityRef getContactList() {
        return this.contactList;
    }

    public void setContactList(DomainEntityRef contactList) {
        this.contactList = contactList;
    }

    public MessagingCampaign dncLists(List<DomainEntityRef> dncLists) {
        this.dncLists = dncLists;
        return this;
    }

    @ApiModelProperty(example="null", value="The dnc lists to check before sending a message for this messaging campaign.")
    @JsonProperty(value="dncLists")
    public List<DomainEntityRef> getDncLists() {
        return this.dncLists;
    }

    public void setDncLists(List<DomainEntityRef> dncLists) {
        this.dncLists = dncLists;
    }

    public MessagingCampaign alwaysRunning(Boolean alwaysRunning) {
        this.alwaysRunning = alwaysRunning;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether this messaging campaign is always running")
    @JsonProperty(value="alwaysRunning")
    public Boolean getAlwaysRunning() {
        return this.alwaysRunning;
    }

    public void setAlwaysRunning(Boolean alwaysRunning) {
        this.alwaysRunning = alwaysRunning;
    }

    public MessagingCampaign contactSorts(List<ContactSort> contactSorts) {
        this.contactSorts = contactSorts;
        return this;
    }

    @ApiModelProperty(example="null", value="The order in which to sort contacts for dialing, based on up to four columns.")
    @JsonProperty(value="contactSorts")
    public List<ContactSort> getContactSorts() {
        return this.contactSorts;
    }

    public void setContactSorts(List<ContactSort> contactSorts) {
        this.contactSorts = contactSorts;
    }

    public MessagingCampaign messagesPerMinute(Integer messagesPerMinute) {
        this.messagesPerMinute = messagesPerMinute;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="How many messages this messaging campaign will send per minute.")
    @JsonProperty(value="messagesPerMinute")
    public Integer getMessagesPerMinute() {
        return this.messagesPerMinute;
    }

    public void setMessagesPerMinute(Integer messagesPerMinute) {
        this.messagesPerMinute = messagesPerMinute;
    }

    public MessagingCampaign contactListFilters(List<DomainEntityRef> contactListFilters) {
        this.contactListFilters = contactListFilters;
        return this;
    }

    @ApiModelProperty(example="null", value="The contact list filter to check before sending a message for this messaging campaign.")
    @JsonProperty(value="contactListFilters")
    public List<DomainEntityRef> getContactListFilters() {
        return this.contactListFilters;
    }

    public void setContactListFilters(List<DomainEntityRef> contactListFilters) {
        this.contactListFilters = contactListFilters;
    }

    public MessagingCampaign errors(List<RestErrorDetail> errors) {
        this.errors = errors;
        return this;
    }

    @ApiModelProperty(example="null", value="A list of current error conditions associated with this messaging campaign.")
    @JsonProperty(value="errors")
    public List<RestErrorDetail> getErrors() {
        return this.errors;
    }

    public void setErrors(List<RestErrorDetail> errors) {
        this.errors = errors;
    }

    public MessagingCampaign smsConfig(SmsConfig smsConfig) {
        this.smsConfig = smsConfig;
        return this;
    }

    @ApiModelProperty(example="null", value="Configuration for this messaging campaign to send SMS messages.")
    @JsonProperty(value="smsConfig")
    public SmsConfig getSmsConfig() {
        return this.smsConfig;
    }

    public void setSmsConfig(SmsConfig smsConfig) {
        this.smsConfig = smsConfig;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessagingCampaign messagingCampaign = (MessagingCampaign)o;
        return Objects.equals(this.id, messagingCampaign.id) && Objects.equals(this.name, messagingCampaign.name) && Objects.equals(this.dateCreated, messagingCampaign.dateCreated) && Objects.equals(this.dateModified, messagingCampaign.dateModified) && Objects.equals(this.version, messagingCampaign.version) && Objects.equals(this.division, messagingCampaign.division) && Objects.equals((Object)this.campaignStatus, (Object)messagingCampaign.campaignStatus) && Objects.equals(this.callableTimeSet, messagingCampaign.callableTimeSet) && Objects.equals(this.contactList, messagingCampaign.contactList) && Objects.equals(this.dncLists, messagingCampaign.dncLists) && Objects.equals(this.alwaysRunning, messagingCampaign.alwaysRunning) && Objects.equals(this.contactSorts, messagingCampaign.contactSorts) && Objects.equals(this.messagesPerMinute, messagingCampaign.messagesPerMinute) && Objects.equals(this.contactListFilters, messagingCampaign.contactListFilters) && Objects.equals(this.errors, messagingCampaign.errors) && Objects.equals(this.smsConfig, messagingCampaign.smsConfig) && Objects.equals(this.selfUri, messagingCampaign.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.dateCreated, this.dateModified, this.version, this.division, this.campaignStatus, this.callableTimeSet, this.contactList, this.dncLists, this.alwaysRunning, this.contactSorts, this.messagesPerMinute, this.contactListFilters, this.errors, this.smsConfig, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MessagingCampaign {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    division: ").append(this.toIndentedString(this.division)).append("\n");
        sb.append("    campaignStatus: ").append(this.toIndentedString((Object)this.campaignStatus)).append("\n");
        sb.append("    callableTimeSet: ").append(this.toIndentedString(this.callableTimeSet)).append("\n");
        sb.append("    contactList: ").append(this.toIndentedString(this.contactList)).append("\n");
        sb.append("    dncLists: ").append(this.toIndentedString(this.dncLists)).append("\n");
        sb.append("    alwaysRunning: ").append(this.toIndentedString(this.alwaysRunning)).append("\n");
        sb.append("    contactSorts: ").append(this.toIndentedString(this.contactSorts)).append("\n");
        sb.append("    messagesPerMinute: ").append(this.toIndentedString(this.messagesPerMinute)).append("\n");
        sb.append("    contactListFilters: ").append(this.toIndentedString(this.contactListFilters)).append("\n");
        sb.append("    errors: ").append(this.toIndentedString(this.errors)).append("\n");
        sb.append("    smsConfig: ").append(this.toIndentedString(this.smsConfig)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=CampaignStatusEnumDeserializer.class)
    public static enum CampaignStatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ON("on"),
        STOPPING("stopping"),
        OFF("off"),
        COMPLETE("complete"),
        INVALID("invalid");

        private String value;

        private CampaignStatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static CampaignStatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (CampaignStatusEnum value : CampaignStatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return CampaignStatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class CampaignStatusEnumDeserializer
    extends StdDeserializer<CampaignStatusEnum> {
        public CampaignStatusEnumDeserializer() {
            super(CampaignStatusEnumDeserializer.class);
        }

        public CampaignStatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return CampaignStatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

