/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.AddressableEntityRef;
import com.mypurecloud.sdk.v2.model.DocumentBody;
import com.mypurecloud.sdk.v2.model.KnowledgeGuestDocumentVariationContext;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class KnowledgeGuestDocumentVariation
implements Serializable {
    private String id = null;
    private DocumentBody body = null;
    private Date dateCreated = null;
    private Date dateModified = null;
    private AddressableEntityRef documentVersion = null;
    private List<KnowledgeGuestDocumentVariationContext> contexts = new ArrayList<KnowledgeGuestDocumentVariationContext>();
    private AddressableEntityRef document = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the variation.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public KnowledgeGuestDocumentVariation body(DocumentBody body) {
        this.body = body;
        return this;
    }

    @ApiModelProperty(example="null", value="The content for the variation.")
    @JsonProperty(value="body")
    public DocumentBody getBody() {
        return this.body;
    }

    public void setBody(DocumentBody body) {
        this.body = body;
    }

    @ApiModelProperty(example="null", value="The creation date-time for the document variation. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    @ApiModelProperty(example="null", value="The last modification date-time for the document variation. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    public KnowledgeGuestDocumentVariation documentVersion(AddressableEntityRef documentVersion) {
        this.documentVersion = documentVersion;
        return this;
    }

    @ApiModelProperty(example="null", value="The version of the document.")
    @JsonProperty(value="documentVersion")
    public AddressableEntityRef getDocumentVersion() {
        return this.documentVersion;
    }

    public void setDocumentVersion(AddressableEntityRef documentVersion) {
        this.documentVersion = documentVersion;
    }

    public KnowledgeGuestDocumentVariation contexts(List<KnowledgeGuestDocumentVariationContext> contexts) {
        this.contexts = contexts;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The context values associated with the variation.")
    @JsonProperty(value="contexts")
    public List<KnowledgeGuestDocumentVariationContext> getContexts() {
        return this.contexts;
    }

    public void setContexts(List<KnowledgeGuestDocumentVariationContext> contexts) {
        this.contexts = contexts;
    }

    @ApiModelProperty(example="null", value="The reference to document to which the variation is associated.")
    @JsonProperty(value="document")
    public AddressableEntityRef getDocument() {
        return this.document;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KnowledgeGuestDocumentVariation knowledgeGuestDocumentVariation = (KnowledgeGuestDocumentVariation)o;
        return Objects.equals(this.id, knowledgeGuestDocumentVariation.id) && Objects.equals(this.body, knowledgeGuestDocumentVariation.body) && Objects.equals(this.dateCreated, knowledgeGuestDocumentVariation.dateCreated) && Objects.equals(this.dateModified, knowledgeGuestDocumentVariation.dateModified) && Objects.equals(this.documentVersion, knowledgeGuestDocumentVariation.documentVersion) && Objects.equals(this.contexts, knowledgeGuestDocumentVariation.contexts) && Objects.equals(this.document, knowledgeGuestDocumentVariation.document) && Objects.equals(this.selfUri, knowledgeGuestDocumentVariation.selfUri);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.body, this.dateCreated, this.dateModified, this.documentVersion, this.contexts, this.document, this.selfUri);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class KnowledgeGuestDocumentVariation {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    body: ").append(this.toIndentedString(this.body)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    documentVersion: ").append(this.toIndentedString(this.documentVersion)).append("\n");
        sb.append("    contexts: ").append(this.toIndentedString(this.contexts)).append("\n");
        sb.append("    document: ").append(this.toIndentedString(this.document)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

